/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainerBuilder;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.ws.actions.AssertSoapFault;
import org.citrusframework.ws.actions.ReceiveSoapMessageAction;
import org.citrusframework.ws.actions.SendSoapFaultAction;
import org.citrusframework.ws.actions.SendSoapMessageAction;
import org.citrusframework.ws.actions.SoapActionBuilder;
import org.citrusframework.ws.actions.SoapClientActionBuilder;
import org.citrusframework.ws.actions.SoapServerActionBuilder;
import org.citrusframework.ws.message.SoapAttachment;
import org.citrusframework.yaml.TestActions;
import org.citrusframework.yaml.actions.Message;
import org.citrusframework.yaml.actions.Receive;
import org.citrusframework.yaml.actions.Send;

public class Soap
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    private TestActionBuilder<?> builder;
    private Receive receive;
    private Send send;
    private String description;
    private String actor;
    private ReferenceResolver referenceResolver;

    public void setDescription(String value) {
        this.description = value;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setClient(String soapClient) {
        this.builder = new SoapActionBuilder().client(soapClient);
    }

    public void setServer(String soapServer) {
        this.builder = new SoapActionBuilder().server(soapServer);
    }

    public void setSendRequest(ClientRequest request) {
        SendSoapMessageAction.Builder requestBuilder = this.asClientBuilder().send();
        requestBuilder.name("soap:send-request");
        requestBuilder.description(this.description);
        this.send = new Send(requestBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (request.fork != null) {
            this.send.setFork(request.fork);
        }
        if (request.extract != null) {
            this.send.setExtract(request.extract);
        }
        if (request.uri != null) {
            ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).header("citrus_endpoint_uri", request.uri);
        }
        if (request.getMessage() != null) {
            this.send.setMessage((Message)request.getMessage());
            if (request.getMessage().contentType != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).contentType(request.getMessage().contentType);
            }
            if (request.getMessage().accept != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).accept(request.getMessage().accept);
            }
            if (request.getMessage().soapAction != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).soapAction(request.getMessage().soapAction);
            }
            if (request.getMessage().mtomEnabled != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).mtomEnabled(request.getMessage().mtomEnabled);
            }
            for (SoapMessage.Attachment attachment : request.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                soapAttachment.setContentResourcePath(attachment.getResource());
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)requestBuilder.message()).attachment(soapAttachment);
            }
        }
        this.builder = requestBuilder;
    }

    public void setReceiveResponse(ClientResponse response) {
        ReceiveSoapMessageAction.Builder responseBuilder = this.asClientBuilder().receive();
        responseBuilder.name("soap:receive-response");
        responseBuilder.description(this.description);
        this.receive = new Receive(responseBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (response.getMessage() != null) {
            if (response.getMessage().status != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).statusCode(Integer.parseInt(response.getMessage().status));
            }
            if (response.getMessage().reasonPhrase != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getMessage().reasonPhrase);
            }
            if (response.getMessage().contentType != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).contentType(response.getMessage().contentType);
            }
            for (SoapMessage.Attachment attachment : response.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                soapAttachment.setContentResourcePath(attachment.getResource());
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).attachment(soapAttachment);
            }
            this.receive.setMessage((Message)response.getMessage());
        }
        if (response.attachmentValidator != null) {
            ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)responseBuilder.message()).attachmentValidatorName(response.attachmentValidator);
        }
        if (response.timeout != null) {
            this.receive.setTimeout(response.timeout);
        }
        this.receive.setSelect(response.select);
        this.receive.setValidator(response.validator);
        this.receive.setValidators(response.validators);
        this.receive.setHeaderValidator(response.headerValidator);
        this.receive.setHeaderValidators(response.headerValidators);
        if (response.selector != null) {
            this.receive.setSelector(response.selector);
        }
        this.receive.setSelect(response.select);
        response.getValidate().forEach(this.receive.getValidate()::add);
        if (response.extract != null) {
            this.receive.setExtract(response.extract);
        }
        this.builder = responseBuilder;
    }

    public void setReceiveRequest(ServerRequest request) {
        ReceiveSoapMessageAction.Builder requestBuilder = this.asServerBuilder().receive();
        requestBuilder.name("soap:receive-request");
        requestBuilder.description(this.description);
        this.receive = new Receive(requestBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (request.getMessage() != null) {
            this.receive.setMessage((Message)request.getMessage());
            if (request.getMessage().contentType != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).contentType(request.getMessage().contentType);
            }
            if (request.getMessage().accept != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).accept(request.getMessage().accept);
            }
            if (request.getMessage().soapAction != null) {
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).soapAction(request.getMessage().soapAction);
            }
            for (SoapMessage.Attachment attachment : request.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                soapAttachment.setContentResourcePath(attachment.getResource());
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).attachment(soapAttachment);
            }
        }
        if (request.attachmentValidator != null) {
            ((ReceiveSoapMessageAction.SoapMessageBuilderSupport)requestBuilder.message()).attachmentValidatorName(request.attachmentValidator);
        }
        if (request.selector != null) {
            this.receive.setSelector(request.selector);
        }
        this.receive.setSelect(request.select);
        this.receive.setValidator(request.validator);
        this.receive.setValidators(request.validators);
        this.receive.setHeaderValidator(request.headerValidator);
        this.receive.setHeaderValidators(request.headerValidators);
        if (request.timeout != null) {
            this.receive.setTimeout(request.timeout);
        }
        request.getValidates().forEach(this.receive.getValidate()::add);
        if (request.extract != null) {
            this.receive.setExtract(request.extract);
        }
        this.builder = requestBuilder;
    }

    public void setSendResponse(ServerResponse response) {
        SendSoapMessageAction.Builder responseBuilder = this.asServerBuilder().send();
        responseBuilder.name("soap:send-response");
        responseBuilder.description(this.description);
        this.send = new Send(responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.getMessage() != null) {
            this.send.setMessage((Message)response.getMessage());
            if (response.extract != null) {
                this.send.setExtract(response.extract);
            }
            if (response.getMessage().status != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", response.getMessage().status);
            }
            if (response.getMessage().reasonPhrase != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).header("citrus_http_reason_phrase", response.getMessage().reasonPhrase);
            }
            if (response.getMessage().contentType != null) {
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).contentType(response.getMessage().contentType);
            }
            for (SoapMessage.Attachment attachment : response.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                soapAttachment.setContentResourcePath(attachment.getResource());
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((SendSoapMessageAction.Builder.SendSoapMessageBuilderSupport)responseBuilder.message()).attachment(soapAttachment);
            }
        }
        this.builder = responseBuilder;
    }

    public void setSendFault(ServerFaultResponse response) {
        SendSoapFaultAction.Builder responseBuilder = this.asServerBuilder().sendFault();
        responseBuilder.name("soap:send-fault");
        responseBuilder.description(this.description);
        this.send = new Send(responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.getMessage() != null) {
            this.send.setMessage((Message)response.getMessage());
            if (response.extract != null) {
                this.send.setExtract(response.extract);
            }
            if (response.getMessage().status != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).statusCode(Integer.parseInt(response.getMessage().status));
            }
            if (response.getMessage().reasonPhrase != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getMessage().reasonPhrase);
            }
            if (response.getMessage().faultCode != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultCode(response.getMessage().faultCode);
            }
            if (response.getMessage().faultString != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultString(response.getMessage().faultString);
            }
            if (response.getMessage().faultActor != null) {
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultActor(response.getMessage().faultActor);
            }
            for (SoapFault.SoapFaultDetail faultDetail : response.getMessage().getFaultDetails()) {
                if (faultDetail.content != null) {
                    ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultDetail(faultDetail.content);
                }
                if (faultDetail.resource == null) continue;
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).faultDetailResource(faultDetail.resource);
            }
            for (SoapMessage.Attachment attachment : response.getMessage().getAttachments()) {
                SoapAttachment soapAttachment = new SoapAttachment();
                soapAttachment.setContentId(attachment.getContentId());
                soapAttachment.setContentType(attachment.getContentType());
                soapAttachment.setContentResourcePath(attachment.getResource());
                if (attachment.getCharset() != null) {
                    soapAttachment.setCharsetName(attachment.getCharset());
                }
                soapAttachment.setContent(attachment.getContent());
                ((SendSoapFaultAction.Builder.SoapFaultMessageBuilderSupport)responseBuilder.message()).attachment(soapAttachment);
            }
        }
        this.builder = responseBuilder;
    }

    public void setAssertFault(ClientAssertFault soapFault) {
        AssertSoapFault.Builder assertFault = this.asClientBuilder().assertFault();
        assertFault.name("soap:assert-fault");
        assertFault.description(this.description);
        if (soapFault.faultCode != null) {
            assertFault.faultCode(soapFault.faultCode);
        }
        if (soapFault.faultString != null) {
            assertFault.faultString(soapFault.faultString);
        }
        if (soapFault.faultActor != null) {
            assertFault.faultActor(soapFault.faultActor);
        }
        for (SoapFault.SoapFaultDetail faultDetail : soapFault.getFaultDetails()) {
            if (faultDetail.content != null) {
                assertFault.faultDetail(faultDetail.content);
            }
            if (faultDetail.resource == null) continue;
            assertFault.faultDetailResource(faultDetail.resource);
        }
        if (soapFault.validator != null) {
            assertFault.validator(soapFault.validator);
        }
        if (!soapFault.getActions().isEmpty()) {
            assertFault.actions((TestActionBuilder<?>[])((TestActionBuilder[])soapFault.getActions().toArray(TestActionBuilder[]::new)));
        }
        this.builder = assertFault;
    }

    public TestAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing client or server Soap action - please provide proper action details");
        }
        if (this.send != null) {
            this.send.setReferenceResolver(this.referenceResolver);
            this.send.setActor(this.actor);
            this.send.build();
        }
        if (this.receive != null) {
            this.receive.setReferenceResolver(this.referenceResolver);
            this.receive.setActor(this.actor);
            this.receive.build();
        }
        if (this.builder instanceof TestActionContainerBuilder) {
            ((TestActionContainerBuilder)this.builder).getActions().stream().filter(action -> action instanceof ReferenceResolverAware).forEach(action -> ((ReferenceResolverAware)action).setReferenceResolver(this.referenceResolver));
        }
        if (this.builder instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)this.builder).setReferenceResolver(this.referenceResolver);
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private SoapClientActionBuilder asClientBuilder() {
        if (this.builder instanceof SoapClientActionBuilder) {
            return (SoapClientActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to soap client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    private SoapServerActionBuilder asServerBuilder() {
        if (this.builder instanceof SoapServerActionBuilder) {
            return (SoapServerActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to soap client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    public static class ClientRequest {
        protected String uri;
        protected Boolean fork;
        protected SoapRequest message;
        protected Message.Extract extract;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public Boolean getFork() {
            return this.fork;
        }

        public void setFork(Boolean fork) {
            this.fork = fork;
        }

        public SoapRequest getMessage() {
            return this.message;
        }

        public void setMessage(SoapRequest message) {
            this.message = message;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class SoapRequest
    extends SoapMessage {
        protected String path;
        protected String contentType;
        protected String accept;
        protected String version;
        protected String soapAction;
        protected Boolean mtomEnabled;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getAccept() {
            return this.accept;
        }

        public void setAccept(String accept) {
            this.accept = accept;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSoapAction() {
            return this.soapAction;
        }

        public void setSoapAction(String soapAction) {
            this.soapAction = soapAction;
        }

        public Boolean getMtomEnabled() {
            return this.mtomEnabled;
        }

        public void setMtomEnabled(Boolean mtomEnabled) {
            this.mtomEnabled = mtomEnabled;
        }
    }

    public static class SoapMessage
    extends Message {
        private List<Attachment> attachments;

        public List<Attachment> getAttachments() {
            if (this.attachments == null) {
                this.attachments = new ArrayList<Attachment>();
            }
            return this.attachments;
        }

        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        public static class Attachment {
            private String contentId;
            private String contentType;
            private String content;
            private String resource;
            private String charset;

            public String getContentId() {
                return this.contentId;
            }

            public void setContentId(String contentId) {
                this.contentId = contentId;
            }

            public String getContentType() {
                return this.contentType;
            }

            public void setContentType(String contentType) {
                this.contentType = contentType;
            }

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public String getCharset() {
                return this.charset;
            }

            public void setCharset(String charset) {
                this.charset = charset;
            }

            public String getResource() {
                return this.resource;
            }

            public void setResource(String resource) {
                this.resource = resource;
            }
        }
    }

    public static class ClientResponse {
        protected Integer timeout;
        protected String select;
        protected String validator;
        protected String validators;
        protected String attachmentValidator;
        protected SoapResponse message;
        protected String headerValidator;
        protected String headerValidators;
        protected Receive.Selector selector;
        protected List<Receive.Validate> validate;
        protected Message.Extract extract;

        public SoapResponse getMessage() {
            return this.message;
        }

        public void setMessage(SoapResponse message) {
            this.message = message;
        }

        public String getAttachmentValidator() {
            return this.attachmentValidator;
        }

        public void setAttachmentValidator(String attachmentValidator) {
            this.attachmentValidator = attachmentValidator;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public List<Receive.Validate> getValidate() {
            if (this.validate == null) {
                this.validate = new ArrayList<Receive.Validate>();
            }
            return this.validate;
        }

        public void setValidate(List<Receive.Validate> validate) {
            this.validate = validate;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class SoapResponse
    extends SoapMessage {
        protected String status;
        protected String reasonPhrase;
        protected String version;
        protected String contentType;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public void setReasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }

    public static class ServerRequest {
        protected Integer timeout;
        protected String select;
        protected String validator;
        protected String validators;
        protected String headerValidator;
        protected String headerValidators;
        protected Receive.Selector selector;
        protected String attachmentValidator;
        protected SoapRequest message;
        protected List<Receive.Validate> validates;
        protected Message.Extract extract;

        public SoapRequest getMessage() {
            return this.message;
        }

        public void setMessage(SoapRequest message) {
            this.message = message;
        }

        public String getAttachmentValidator() {
            return this.attachmentValidator;
        }

        public void setAttachmentValidator(String attachmentValidator) {
            this.attachmentValidator = attachmentValidator;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class ServerResponse {
        protected Message.Extract extract;
        protected SoapResponse message;

        public SoapResponse getMessage() {
            return this.message;
        }

        public void setMessage(SoapResponse message) {
            this.message = message;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class ServerFaultResponse {
        protected Message.Extract extract;
        protected SoapFault message;

        public SoapFault getMessage() {
            return this.message;
        }

        public void setMessage(SoapFault message) {
            this.message = message;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class SoapFault
    extends SoapResponse {
        protected String faultCode;
        protected String faultString;
        protected String faultActor;
        protected List<SoapFaultDetail> faultDetails;

        public void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        public String getFaultCode() {
            return this.faultCode;
        }

        public void setFaultString(String faultString) {
            this.faultString = faultString;
        }

        public String getFaultString() {
            return this.faultString;
        }

        public void setFaultActor(String faultActor) {
            this.faultActor = faultActor;
        }

        public String getFaultActor() {
            return this.faultActor;
        }

        public void setFaultDetails(List<SoapFaultDetail> faultDetails) {
            this.faultDetails = faultDetails;
        }

        public List<SoapFaultDetail> getFaultDetails() {
            if (this.faultDetails == null) {
                this.faultDetails = new ArrayList<SoapFaultDetail>();
            }
            return this.faultDetails;
        }

        public static class SoapFaultDetail {
            protected String content;
            protected String resource;

            public void setContent(String content) {
                this.content = content;
            }

            public String getContent() {
                return this.content;
            }

            public void setResource(String resource) {
                this.resource = resource;
            }

            public String getResource() {
                return this.resource;
            }
        }
    }

    public static class ClientAssertFault
    extends SoapFault {
        protected String validator;
        protected List<TestActionBuilder<?>> actions;

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public void setWhen(List<TestActions> actions) {
            this.getActions().addAll(actions.stream().map(TestActions::get).toList());
        }

        public void setActions(List<TestActions> actions) {
            this.getActions().addAll(actions.stream().map(TestActions::get).toList());
        }

        public List<TestActionBuilder<?>> getActions() {
            if (this.actions == null) {
                this.actions = new ArrayList();
            }
            return this.actions;
        }
    }
}

