/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ws.message;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.ws.message.SoapAttachment;
import org.springframework.http.HttpStatus;

public class SoapMessage
extends DefaultMessage {
    private static final long serialVersionUID = 3289201140229458069L;
    private final List<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
    private boolean mtomEnabled = false;

    public SoapMessage() {
    }

    public SoapMessage(Message message) {
        super(message);
    }

    public SoapMessage(Object payload) {
        this(payload, new LinkedHashMap<String, Object>());
    }

    public SoapMessage(Object payload, Map<String, Object> headers) {
        super(payload, headers);
    }

    public SoapMessage header(String headerName, Object headerValue) {
        return (SoapMessage)super.setHeader(headerName, headerValue);
    }

    public SoapMessage setHeader(String headerName, Object headerValue) {
        return (SoapMessage)super.setHeader(headerName, headerValue);
    }

    public SoapMessage addHeaderData(String headerData) {
        return (SoapMessage)super.addHeaderData(headerData);
    }

    public SoapMessage contentType(String contentType) {
        this.setHeader("citrus_http_Content-Type", contentType);
        return this;
    }

    public SoapMessage accept(String accept) {
        this.setHeader("citrus_http_Accept", accept);
        return this;
    }

    public SoapMessage status(HttpStatus statusCode) {
        this.statusCode(statusCode.value());
        this.reasonPhrase(statusCode.name());
        return this;
    }

    public SoapMessage statusCode(Integer statusCode) {
        this.setHeader("citrus_http_status_code", statusCode);
        return this;
    }

    public SoapMessage reasonPhrase(String reasonPhrase) {
        this.setHeader("citrus_http_reason_phrase", reasonPhrase);
        return this;
    }

    public SoapMessage soapAction(String soapAction) {
        this.setHeader("citrus_soap_action", soapAction);
        return this;
    }

    public SoapMessage mtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
        return this;
    }

    public SoapMessage addAttachment(SoapAttachment attachment) {
        this.attachments.add(attachment);
        return this;
    }

    public String getSoapAction() {
        return Optional.ofNullable(this.getHeader("citrus_soap_action")).map(Object::toString).orElse(null);
    }

    public List<SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public String toString() {
        return super.toString() + String.format("[attachments: %s]", this.attachments);
    }
}

