/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.variable.dictionary.xml;

import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathConstants;
import org.citrusframework.XmlValidationHelper;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.citrusframework.variable.dictionary.xml.AbstractXmlDataDictionary;
import org.citrusframework.xml.namespace.DefaultNamespaceContext;
import org.citrusframework.xml.namespace.NamespaceContextBuilder;
import org.citrusframework.xml.xpath.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XpathMappingDataDictionary
extends AbstractXmlDataDictionary
implements InitializingPhase {
    private static final Logger logger = LoggerFactory.getLogger(XpathMappingDataDictionary.class);
    private NamespaceContextBuilder namespaceContextBuilder;

    public <T> T translate(Node node, T value, TestContext context) {
        for (Map.Entry expressionEntry : this.mappings.entrySet()) {
            String expression = (String)expressionEntry.getKey();
            NodeList findings = (NodeList)XPathUtils.evaluateExpression(node.getOwnerDocument(), expression, this.buildNamespaceContext(node, context), XPathConstants.NODESET);
            if (findings == null || !this.containsNode(findings, node)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Data dictionary setting element '%s' value: %s", XMLUtils.getNodesPathName(node), expressionEntry.getValue()));
            }
            return (T)this.convertIfNecessary((String)expressionEntry.getValue(), value, context);
        }
        return value;
    }

    private boolean containsNode(NodeList findings, Node node) {
        for (int i = 0; i < findings.getLength(); ++i) {
            if (!findings.item(i).equals(node)) continue;
            return true;
        }
        return false;
    }

    private NamespaceContext buildNamespaceContext(Node node, TestContext context) {
        DefaultNamespaceContext simpleNamespaceContext = new DefaultNamespaceContext();
        Map<String, String> namespaces = XMLUtils.lookupNamespaces(node.getOwnerDocument());
        namespaces.putAll(this.getNamespaceContextBuilder(context).getNamespaceMappings());
        simpleNamespaceContext.addNamespaces(namespaces);
        return simpleNamespaceContext;
    }

    public void initialize() {
        if (this.getPathMappingStrategy() != null && !this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.EXACT)) {
            logger.warn(String.format("%s ignores path mapping strategy other than %s", ((Object)((Object)this)).getClass().getSimpleName(), DataDictionary.PathMappingStrategy.EXACT));
        }
        super.initialize();
    }

    private NamespaceContextBuilder getNamespaceContextBuilder(TestContext context) {
        if (this.namespaceContextBuilder != null) {
            return this.namespaceContextBuilder;
        }
        return XmlValidationHelper.getNamespaceContextBuilder(context);
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }
}

