/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.builder;

import java.util.Map;
import javax.xml.transform.Result;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.builder.DefaultHeaderDataBuilder;
import org.citrusframework.xml.Marshaller;
import org.citrusframework.xml.StringResult;

public class MarshallingHeaderDataBuilder
extends DefaultHeaderDataBuilder {
    private final Marshaller marshaller;
    private final String marshallerName;

    public MarshallingHeaderDataBuilder(Object model) {
        super(model);
        this.marshaller = null;
        this.marshallerName = null;
    }

    public MarshallingHeaderDataBuilder(Object model, Marshaller marshaller) {
        super(model);
        this.marshaller = marshaller;
        this.marshallerName = null;
    }

    public MarshallingHeaderDataBuilder(Object model, String marshallerName) {
        super(model);
        this.marshallerName = marshallerName;
        this.marshaller = null;
    }

    public String buildHeaderData(TestContext context) {
        if (this.getHeaderData() == null || this.getHeaderData() instanceof String) {
            return super.buildHeaderData(context);
        }
        if (this.marshaller != null) {
            return this.buildHeaderData(this.marshaller, this.getHeaderData(), context);
        }
        if (this.marshallerName != null) {
            if (context.getReferenceResolver().isResolvable(this.marshallerName)) {
                Marshaller objectMapper = (Marshaller)context.getReferenceResolver().resolve(this.marshallerName, Marshaller.class);
                return this.buildHeaderData(objectMapper, this.getHeaderData(), context);
            }
            throw new CitrusRuntimeException(String.format("Unable to find proper object marshaller for name '%s'", this.marshallerName));
        }
        Map marshallerMap = context.getReferenceResolver().resolveAll(Marshaller.class);
        if (marshallerMap.size() == 1) {
            return this.buildHeaderData((Marshaller)marshallerMap.values().iterator().next(), this.getHeaderData(), context);
        }
        throw new CitrusRuntimeException(String.format("Unable to auto detect object marshaller - found %d matching marshaller instances in reference resolver", marshallerMap.size()));
    }

    private String buildHeaderData(Marshaller marshaller, Object model, TestContext context) {
        StringResult result = new StringResult();
        try {
            marshaller.marshal(model, (Result)result);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message header data", (Throwable)e);
        }
        return context.replaceDynamicContentInString(result.toString());
    }
}

