/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import org.citrusframework.XmlValidationHelper;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.UnknownElementException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.validation.AbstractMessageValidator;
import org.citrusframework.validation.ValidationUtils;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.xml.DomXmlMessageValidator;
import org.citrusframework.validation.xml.XmlValidationUtils;
import org.citrusframework.validation.xml.XpathMessageValidationContext;
import org.citrusframework.xml.namespace.NamespaceContextBuilder;
import org.citrusframework.xml.xpath.XPathExpressionResult;
import org.citrusframework.xml.xpath.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathMessageValidator
extends AbstractMessageValidator<XpathMessageValidationContext> {
    private static final Logger logger = LoggerFactory.getLogger(XpathMessageValidator.class);
    private NamespaceContextBuilder namespaceContextBuilder;

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, XpathMessageValidationContext validationContext) throws ValidationException {
        if (validationContext.getXpathExpressions().isEmpty()) {
            return;
        }
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)((String)receivedMessage.getPayload(String.class)))) {
            throw new ValidationException("Unable to validate message elements - receive message payload was empty");
        }
        logger.debug("Start XPath element validation ...");
        Document received = XMLUtils.parseMessagePayload((String)receivedMessage.getPayload(String.class));
        NamespaceContext namespaceContext = this.getNamespaceContextBuilder(context).buildContext(receivedMessage, validationContext.getNamespaces());
        for (Map.Entry entry : validationContext.getXpathExpressions().entrySet()) {
            Object xPathResult;
            String xPathExpression = (String)entry.getKey();
            Object expectedValue = entry.getValue();
            if (XPathUtils.isXPathExpression(xPathExpression = context.replaceDynamicContentInString(xPathExpression))) {
                XPathExpressionResult resultType = XPathExpressionResult.fromString(xPathExpression, XPathExpressionResult.NODE);
                xPathExpression = XPathExpressionResult.cutOffPrefix(xPathExpression);
                if (resultType.equals((Object)XPathExpressionResult.NODE) && XmlValidationUtils.isElementIgnored(XPathUtils.evaluateAsNode(received, xPathExpression, namespaceContext), validationContext.getIgnoreExpressions(), namespaceContext)) continue;
                xPathResult = XPathUtils.evaluate(received, xPathExpression, namespaceContext, resultType);
            } else {
                Node node = XMLUtils.findNodeByName(received, xPathExpression);
                if (node == null) {
                    throw new UnknownElementException("Element ' " + xPathExpression + "' could not be found in DOM tree");
                }
                if (XmlValidationUtils.isElementIgnored(node, validationContext.getIgnoreExpressions(), namespaceContext)) continue;
                xPathResult = this.getNodeValue(node);
            }
            if (expectedValue instanceof String) {
                expectedValue = context.replaceDynamicContentInString(String.valueOf(expectedValue));
            }
            ValidationUtils.validateValues((Object)xPathResult, expectedValue, (String)xPathExpression, (TestContext)context);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Validating element: " + xPathExpression + "='" + expectedValue + "': OK.");
        }
        logger.info("XPath element validation successful: All elements OK");
    }

    protected Class<XpathMessageValidationContext> getRequiredValidationContextType() {
        return XpathMessageValidationContext.class;
    }

    public XpathMessageValidationContext findValidationContext(List<ValidationContext> validationContexts) {
        List xpathMessageValidationContexts = validationContexts.stream().filter(XpathMessageValidationContext.class::isInstance).map(XpathMessageValidationContext.class::cast).collect(Collectors.toList());
        if (xpathMessageValidationContexts.size() > 1) {
            XpathMessageValidationContext xpathMessageValidationContext = (XpathMessageValidationContext)xpathMessageValidationContexts.get(0);
            Map xpathExpressions = xpathMessageValidationContexts.stream().map(XpathMessageValidationContext::getXpathExpressions).reduce((collect, map) -> {
                collect.putAll(map);
                return collect;
            }).orElseGet(Collections::emptyMap);
            if (!xpathExpressions.isEmpty()) {
                xpathMessageValidationContext.getXpathExpressions().putAll(xpathExpressions);
                return xpathMessageValidationContext;
            }
        }
        return (XpathMessageValidationContext)super.findValidationContext(validationContexts);
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return new DomXmlMessageValidator().supportsMessageType(messageType, message);
    }

    private String getNodeValue(Node node) {
        if (node.getNodeType() == 1 && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return node.getNodeValue();
    }

    private NamespaceContextBuilder getNamespaceContextBuilder(TestContext context) {
        if (this.namespaceContextBuilder != null) {
            return this.namespaceContextBuilder;
        }
        return XmlValidationHelper.getNamespaceContextBuilder(context);
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }
}

