/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xhtml;

import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.MessageUtils;
import org.citrusframework.validation.xhtml.XhtmlMessageConverter;
import org.citrusframework.validation.xml.DomXmlMessageValidator;
import org.citrusframework.validation.xml.XmlMessageValidationContext;

public class XhtmlMessageValidator
extends DomXmlMessageValidator
implements InitializingPhase {
    private XhtmlMessageConverter messageConverter = new XhtmlMessageConverter();

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, XmlMessageValidationContext validationContext) throws ValidationException {
        String messagePayload = (String)receivedMessage.getPayload(String.class);
        super.validateMessage((Message)new DefaultMessage((Object)this.messageConverter.convert(messagePayload), receivedMessage.getHeaders()), controlMessage, context, validationContext);
    }

    @Override
    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.XHTML.name()) && MessageUtils.hasXmlPayload((Message)message);
    }

    public void initialize() {
        this.messageConverter.initialize();
    }

    public void setMessageConverter(XhtmlMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public XhtmlMessageConverter getMessageConverter() {
        return this.messageConverter;
    }
}

