/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.core;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.matcher.ValidationMatcher;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlValidationMatcher
implements ValidationMatcher {
    private static final String CDATA_SECTION_START = "<![CDATA[";
    private static final String CDATA_SECTION_END = "]]>";
    private MessageValidator<? extends ValidationContext> messageValidator;
    public static final String DEFAULT_XML_MESSAGE_VALIDATOR = "defaultXmlMessageValidator";
    private static final Logger logger = LoggerFactory.getLogger(XmlValidationMatcher.class);

    public void validate(String fieldName, String value, List<String> controlParameters, TestContext context) throws ValidationException {
        String control = controlParameters.get(0);
        XmlMessageValidationContext validationContext = new XmlMessageValidationContext();
        this.getMessageValidator(context).validateMessage((Message)new DefaultMessage((Object)this.removeCDataElements(value)), (Message)new DefaultMessage((Object)control), context, Collections.singletonList(validationContext));
    }

    private MessageValidator<? extends ValidationContext> getMessageValidator(TestContext context) {
        if (this.messageValidator != null) {
            return this.messageValidator;
        }
        Optional<MessageValidator> defaultMessageValidator = context.getMessageValidatorRegistry().findMessageValidator(DEFAULT_XML_MESSAGE_VALIDATOR);
        if (!defaultMessageValidator.isPresent()) {
            try {
                defaultMessageValidator = Optional.of((MessageValidator)context.getReferenceResolver().resolve(DEFAULT_XML_MESSAGE_VALIDATOR, MessageValidator.class));
            }
            catch (CitrusRuntimeException e) {
                logger.warn("Unable to find default XML message validator in message validator registry");
            }
        }
        if (!defaultMessageValidator.isPresent()) {
            defaultMessageValidator = MessageValidator.lookup((String)"xml");
        }
        if (defaultMessageValidator.isPresent()) {
            this.messageValidator = defaultMessageValidator.get();
            return this.messageValidator;
        }
        throw new CitrusRuntimeException("Unable to locate proper XML message validator - please add validator to project");
    }

    private String removeCDataElements(String value) {
        String data = value.trim();
        if (data.startsWith(CDATA_SECTION_START)) {
            data = value.substring(CDATA_SECTION_START.length());
            data = data.substring(0, data.length() - CDATA_SECTION_END.length());
        }
        return data;
    }
}

