/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.builder;

import java.util.Map;
import javax.xml.transform.Result;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.builder.DefaultPayloadBuilder;
import org.citrusframework.xml.Marshaller;
import org.citrusframework.xml.StringResult;

public class MarshallingPayloadBuilder
extends DefaultPayloadBuilder {
    private final Marshaller marshaller;
    private final String marshallerName;

    public MarshallingPayloadBuilder(Object model) {
        super(model);
        this.marshaller = null;
        this.marshallerName = null;
    }

    public MarshallingPayloadBuilder(Object model, Marshaller marshaller) {
        super(model);
        this.marshaller = marshaller;
        this.marshallerName = null;
    }

    public MarshallingPayloadBuilder(Object model, String marshallerName) {
        super(model);
        this.marshallerName = marshallerName;
        this.marshaller = null;
    }

    public Object buildPayload(TestContext context) {
        if (this.getPayload() == null || this.getPayload() instanceof String) {
            return super.buildPayload(context);
        }
        if (this.marshaller != null) {
            return this.buildPayload(this.marshaller, this.getPayload(), context);
        }
        if (this.marshallerName != null) {
            if (context.getReferenceResolver().isResolvable(this.marshallerName)) {
                Marshaller objectMapper = (Marshaller)context.getReferenceResolver().resolve(this.marshallerName, Marshaller.class);
                return this.buildPayload(objectMapper, this.getPayload(), context);
            }
            throw new CitrusRuntimeException(String.format("Unable to find proper object marshaller for name '%s'", this.marshallerName));
        }
        Map marshallerMap = context.getReferenceResolver().resolveAll(Marshaller.class);
        if (marshallerMap.size() == 1) {
            return this.buildPayload((Marshaller)marshallerMap.values().iterator().next(), this.getPayload(), context);
        }
        throw new CitrusRuntimeException(String.format("Unable to auto detect object marshaller - found %d matching marshaller instances in reference resolver", marshallerMap.size()));
    }

    private Object buildPayload(Marshaller marshaller, Object model, TestContext context) {
        StringResult result = new StringResult();
        try {
            marshaller.marshal(model, (Result)result);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message payload", (Throwable)e);
        }
        return context.replaceDynamicContentInString(result.toString());
    }

    public static class Builder
    implements MessagePayloadBuilder.Builder<MarshallingPayloadBuilder, Builder> {
        private Object model;
        private Marshaller marshaller;
        private String marshallerName;

        public static Builder marshal(Object model) {
            Builder builder = new Builder();
            builder.model = model;
            return builder;
        }

        public static Builder marshal(Object model, String marshaller) {
            Builder builder = new Builder();
            builder.model = model;
            builder.marshallerName = marshaller;
            return builder;
        }

        public static Builder marshal(Object model, Marshaller marshaller) {
            Builder builder = new Builder();
            builder.model = model;
            builder.marshaller = marshaller;
            return builder;
        }

        public Builder marshaller(String marshallerName) {
            this.marshallerName = marshallerName;
            return this;
        }

        public Builder marshaller(Marshaller marshaller) {
            this.marshaller = marshaller;
            return this;
        }

        public MarshallingPayloadBuilder build() {
            if (this.marshaller != null) {
                return new MarshallingPayloadBuilder(this.model, this.marshaller);
            }
            if (this.marshallerName != null) {
                return new MarshallingPayloadBuilder(this.model, this.marshallerName);
            }
            return new MarshallingPayloadBuilder(this.model);
        }
    }
}

