/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.citrusframework.builder.WithExpressions;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.UnknownElementException;
import org.citrusframework.message.AbstractMessageProcessor;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.xml.xpath.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathMessageProcessor
extends AbstractMessageProcessor {
    private final Map<String, Object> xPathExpressions;
    private static final Logger LOG = LoggerFactory.getLogger(XpathMessageProcessor.class);

    public XpathMessageProcessor() {
        this(new Builder());
    }

    private XpathMessageProcessor(Builder builder) {
        this.xPathExpressions = builder.expressions;
    }

    public void processMessage(Message message, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return;
        }
        Document doc = XMLUtils.parseMessagePayload((String)message.getPayload(String.class));
        if (doc == null) {
            throw new CitrusRuntimeException("Not able to set message elements, because no XML ressource defined");
        }
        for (Map.Entry<String, Object> entry : this.xPathExpressions.entrySet()) {
            String pathExpression = entry.getKey();
            String valueExpression = entry.getValue().toString();
            valueExpression = context.replaceDynamicContentInString(valueExpression);
            Node node = XPathUtils.isXPathExpression(pathExpression) ? XPathUtils.evaluateAsNode(doc, pathExpression, context.getNamespaceContextBuilder().buildContext(message, Collections.emptyMap())) : XMLUtils.findNodeByName(doc, pathExpression);
            if (node == null) {
                throw new UnknownElementException("Could not find element for expression" + pathExpression);
            }
            if (node.getNodeType() == 1) {
                node.setTextContent(valueExpression);
            } else {
                node.setNodeValue(valueExpression);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Element " + pathExpression + " was set to value: " + valueExpression);
        }
        message.setPayload((Object)XMLUtils.serialize(doc));
    }

    public boolean supportsMessageType(String messageType) {
        return MessageType.XML.toString().equalsIgnoreCase(messageType) || MessageType.XHTML.toString().equalsIgnoreCase(messageType);
    }

    public Map<String, Object> getXPathExpressions() {
        return this.xPathExpressions;
    }

    public static final class Builder
    implements MessageProcessor.Builder<XpathMessageProcessor, Builder>,
    WithExpressions<Builder> {
        private final Map<String, Object> expressions = new LinkedHashMap<String, Object>();

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object expectedValue) {
            this.expressions.put(expression, expectedValue);
            return this;
        }

        public XpathMessageProcessor build() {
            return new XpathMessageProcessor(this);
        }
    }
}

