/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.xml.xpath.XPathUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.xml.SimpleNamespaceContext;

public class XpathFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        if (parameterList.size() < 2) {
            throw new InvalidFunctionUsageException("Missing parameter for function - usage xpath('xmlSource', 'expression')");
        }
        String xmlSource = parameterList.get(0);
        String xpathExpression = parameterList.get(1);
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.setBindings(context.getNamespaceContextBuilder().getNamespaceMappings());
        return XPathUtils.evaluateAsString(XMLUtils.parseMessagePayload(context.replaceDynamicContentInString(xmlSource)), context.replaceDynamicContentInString(xpathExpression), (NamespaceContext)namespaceContext);
    }
}

