/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.xml.XmlConfigurer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public final class XMLUtils {
    private static XmlConfigurer configurer = new XmlConfigurer();

    private XMLUtils() {
    }

    public static void initialize(XmlConfigurer xmlConfigurer) {
        configurer = xmlConfigurer;
    }

    public static LSParser createLSParser() {
        return configurer.createLSParser();
    }

    public static LSSerializer createLSSerializer() {
        return configurer.createLSSerializer();
    }

    public static LSInput createLSInput() {
        return configurer.createLSInput();
    }

    public static LSOutput createLSOutput() {
        return configurer.createLSOutput();
    }

    public static Node findNodeByName(Document doc, String pathExpression) {
        StringTokenizer tok = new StringTokenizer(pathExpression, ".");
        int numToks = tok.countTokens();
        if (numToks == 1) {
            NodeList elements = doc.getElementsByTagNameNS("*", pathExpression);
            return elements.item(0);
        }
        String element = pathExpression.substring(pathExpression.lastIndexOf(46) + 1);
        NodeList elements = doc.getElementsByTagNameNS("*", element);
        String attributeName = null;
        if (elements.getLength() == 0) {
            attributeName = element;
            Node found = XMLUtils.findNodeByName(doc, pathExpression.substring(0, pathExpression.length() - attributeName.length() - 1));
            if (found != null) {
                return found.getAttributes().getNamedItem(attributeName);
            }
            return null;
        }
        for (int j = 0; j < elements.getLength(); ++j) {
            int cnt = numToks - 1;
            StringBuffer pathName = new StringBuffer(element);
            Node parent = elements.item(j).getParentNode();
            do {
                if (parent == null) continue;
                pathName.insert(0, '.');
                pathName.insert(0, parent.getLocalName());
                parent = parent.getParentNode();
            } while (parent != null && --cnt > 0);
            if (!pathName.toString().equals(pathExpression)) continue;
            return elements.item(j);
        }
        return null;
    }

    public static void stripWhitespaceNodes(Node element) {
        Node child = element.getFirstChild();
        while (child != null) {
            Node node = child.getNextSibling();
            XMLUtils.stripWhitespaceNodes(child);
            child = node;
        }
        if (element.getNodeType() == 3 && element.getNodeValue().trim().length() == 0) {
            element.getParentNode().removeChild(element);
        }
    }

    public static String getNodesPathName(Node node) {
        StringBuffer buffer = new StringBuffer();
        if (node.getNodeType() == 2) {
            XMLUtils.buildNodeName(((Attr)node).getOwnerElement(), buffer);
            buffer.append(".");
            buffer.append(node.getLocalName());
        } else {
            XMLUtils.buildNodeName(node, buffer);
        }
        return buffer.toString();
    }

    private static void buildNodeName(Node node, StringBuffer buffer) {
        if (node.getParentNode() == null) {
            return;
        }
        XMLUtils.buildNodeName(node.getParentNode(), buffer);
        if (node.getParentNode() != null && node.getParentNode().getParentNode() != null) {
            buffer.append(".");
        }
        buffer.append(node.getLocalName());
    }

    public static String serialize(Document doc) {
        LSSerializer serializer = configurer.createLSSerializer();
        LSOutput output = configurer.createLSOutput();
        String charset = XMLUtils.getTargetCharset(doc).displayName();
        output.setEncoding(charset);
        StringWriter writer = new StringWriter();
        output.setCharacterStream(writer);
        serializer.write(doc, output);
        return writer.toString();
    }

    public static String prettyPrint(String xml) {
        Document doc;
        LSParser parser = configurer.createLSParser();
        configurer.setParserConfigParameter(parser, "validate-if-schema", false);
        LSInput input = configurer.createLSInput();
        try {
            Charset charset = XMLUtils.getTargetCharset(xml);
            input.setByteStream(new ByteArrayInputStream(xml.trim().getBytes(charset)));
            input.setEncoding(charset.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        try {
            doc = parser.parse(input);
        }
        catch (Exception e) {
            return xml;
        }
        return XMLUtils.serialize(doc);
    }

    public static Map<String, String> lookupNamespaces(Node referenceNode) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        Node node = referenceNode.getNodeType() == 9 ? referenceNode.getFirstChild() : referenceNode;
        if (node != null && node.hasAttributes()) {
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                Node attribute = node.getAttributes().item(i);
                if (attribute.getNodeName().startsWith("xmlns:")) {
                    namespaces.put(attribute.getNodeName().substring("xmlns:".length()), attribute.getNodeValue());
                    continue;
                }
                if (!attribute.getNodeName().startsWith("xmlns")) continue;
                namespaces.put("", attribute.getNodeValue());
            }
        }
        return namespaces;
    }

    public static Document parseMessagePayload(String messagePayload) {
        LSParser parser = configurer.createLSParser();
        LSInput receivedInput = configurer.createLSInput();
        try {
            Charset charset = XMLUtils.getTargetCharset(messagePayload);
            receivedInput.setByteStream(new ByteArrayInputStream(messagePayload.trim().getBytes(charset)));
            receivedInput.setEncoding(charset.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        return parser.parse(receivedInput);
    }

    public static Charset getTargetCharset(Document doc) {
        String defaultEncoding = System.getProperty("citrus.file.encoding", System.getenv("CITRUS_FILE_ENCODING"));
        if (StringUtils.hasText((String)defaultEncoding)) {
            return Charset.forName(defaultEncoding);
        }
        if (doc.getInputEncoding() != null) {
            return Charset.forName(doc.getInputEncoding());
        }
        return StandardCharsets.UTF_8;
    }

    private static Charset getTargetCharset(String messagePayload) throws UnsupportedEncodingException {
        String defaultEncoding = System.getProperty("citrus.file.encoding", System.getenv("CITRUS_FILE_ENCODING"));
        if (StringUtils.hasText((String)defaultEncoding)) {
            return Charset.forName(defaultEncoding);
        }
        String payload = messagePayload.trim();
        int doubleQuote = 34;
        int singleQuote = 39;
        String encodingKey = "encoding";
        if (payload.startsWith("<?xml") && payload.contains(encodingKey) && payload.contains("?>") && payload.indexOf(encodingKey) < payload.indexOf("?>")) {
            String encoding = payload.substring(payload.indexOf(encodingKey) + encodingKey.length(), payload.indexOf("?>"));
            int quoteChar = doubleQuote;
            int idxDoubleQuote = encoding.indexOf(doubleQuote);
            int idxSingleQuote = encoding.indexOf(singleQuote);
            if (idxSingleQuote >= 0 && (idxDoubleQuote < 0 || idxSingleQuote < idxDoubleQuote)) {
                quoteChar = singleQuote;
            }
            encoding = encoding.substring(encoding.indexOf(quoteChar) + 1);
            encoding = encoding.substring(0, encoding.indexOf(quoteChar));
            if (!Charset.availableCharsets().containsKey(encoding)) {
                throw new UnsupportedEncodingException("Found unsupported encoding: '" + encoding + "'");
            }
            return Charset.forName(encoding);
        }
        return StandardCharsets.UTF_8;
    }

    public static String omitXmlDeclaration(String xml) {
        if (xml.startsWith("<?xml") && xml.contains("?>")) {
            return xml.substring(xml.indexOf("?>") + 2).trim();
        }
        return xml;
    }

    static {
        configurer.initialize();
    }
}

