/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.json.JsonSchemaRepository;
import org.citrusframework.json.schema.SimpleJsonSchema;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.validation.context.MessageValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaFilter {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaFilter.class);

    public List<SimpleJsonSchema> filter(List<JsonSchemaRepository> schemaRepositories, MessageValidationContext jsonMessageValidationContext, ReferenceResolver referenceResolver) {
        if (this.isSchemaRepositorySpecified(jsonMessageValidationContext)) {
            return this.filterByRepositoryName(schemaRepositories, jsonMessageValidationContext);
        }
        if (this.isSchemaSpecified(jsonMessageValidationContext)) {
            return this.getSchemaFromContext(jsonMessageValidationContext, referenceResolver);
        }
        return this.mergeRepositories(schemaRepositories);
    }

    private List<SimpleJsonSchema> getSchemaFromContext(MessageValidationContext jsonMessageValidationContext, ReferenceResolver referenceResolver) {
        SimpleJsonSchema simpleJsonSchema = (SimpleJsonSchema)referenceResolver.resolve(jsonMessageValidationContext.getSchema(), SimpleJsonSchema.class);
        if (logger.isDebugEnabled()) {
            logger.debug("Found specified schema: \"" + jsonMessageValidationContext.getSchema() + "\".");
        }
        return Collections.singletonList(simpleJsonSchema);
    }

    private List<SimpleJsonSchema> filterByRepositoryName(List<JsonSchemaRepository> schemaRepositories, MessageValidationContext jsonMessageValidationContext) {
        for (JsonSchemaRepository jsonSchemaRepository : schemaRepositories) {
            if (!Objects.equals(jsonSchemaRepository.getName(), jsonMessageValidationContext.getSchemaRepository())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Found specified schema-repository: \"" + jsonMessageValidationContext.getSchemaRepository() + "\".");
            }
            return jsonSchemaRepository.getSchemas();
        }
        throw new CitrusRuntimeException("Could not find the specified schema repository: \"" + jsonMessageValidationContext.getSchemaRepository() + "\".");
    }

    private List<SimpleJsonSchema> mergeRepositories(List<JsonSchemaRepository> schemaRepositories) {
        return schemaRepositories.stream().map(JsonSchemaRepository::getSchemas).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isSchemaSpecified(MessageValidationContext context) {
        return context.getSchema() != null && !context.getSchema().isEmpty() && !context.getSchema().isBlank();
    }

    private boolean isSchemaRepositorySpecified(MessageValidationContext context) {
        return context.getSchemaRepository() != null && !context.getSchemaRepository().isEmpty() && !context.getSchemaRepository().isBlank();
    }
}

