/*
 * Copyright the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.citrusframework.functions.core;

import java.util.List;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.json.JsonPathUtils;

/**
 * @since 2.6.2
 */
public class JsonPathFunction implements Function {

    @Override
    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }

        if (parameterList.size() < 2) {
            throw new InvalidFunctionUsageException("Missing parameter for function - usage jsonPath('jsonSource', 'expression')");
        }

        String jsonSource;
        String jsonPathExpression;
        if (parameterList.size() > 2) {
            StringBuilder sb = new StringBuilder();
            sb.append(parameterList.get(0));
            for (int i = 1; i < parameterList.size() -1; i++) {
                sb.append(", ").append(parameterList.get(i));
            }

            jsonSource = sb.toString();
            jsonPathExpression = parameterList.get(parameterList.size() - 1);
        } else {
            jsonSource = parameterList.get(0);
            jsonPathExpression = parameterList.get(1);
        }

        return JsonPathUtils.evaluateAsString(context.replaceDynamicContentInString(jsonSource), jsonPathExpression);
    }
}
