/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.json.JsonSchemaRepository;
import org.citrusframework.json.JsonSettings;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.MessageUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.AbstractMessageValidator;
import org.citrusframework.validation.ValidationUtils;
import org.citrusframework.validation.json.JsonMessageValidationContext;
import org.citrusframework.validation.json.schema.JsonSchemaValidation;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;

public class JsonTextMessageValidator
extends AbstractMessageValidator<JsonMessageValidationContext> {
    private boolean strict = JsonSettings.isStrict();
    private int permissiveMode = JsonSettings.getPermissiveMoe();
    private JsonSchemaValidation jsonSchemaValidation = new JsonSchemaValidation();

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, JsonMessageValidationContext validationContext) {
        block9: {
            if (controlMessage == null || controlMessage.getPayload() == null) {
                logger.debug("Skip message payload validation as no control message was defined");
                return;
            }
            logger.debug("Start JSON message validation ...");
            if (validationContext.isSchemaValidationEnabled()) {
                this.jsonSchemaValidation.validate(receivedMessage, context, validationContext);
            }
            String receivedJsonText = (String)receivedMessage.getPayload(String.class);
            String controlJsonText = context.replaceDynamicContentInString((String)controlMessage.getPayload(String.class));
            try {
                if (!StringUtils.hasText((String)controlJsonText)) {
                    logger.debug("Skip message payload validation as no control message was defined");
                    return;
                }
                if (!StringUtils.hasText((String)receivedJsonText)) {
                    throw new ValidationException("Validation failed - expected message contents, but received empty message!");
                }
                JSONParser parser = new JSONParser(this.permissiveMode);
                Object receivedJson = parser.parse(receivedJsonText);
                DocumentContext readContext = JsonPath.parse((Object)receivedJson);
                Object controlJson = parser.parse(controlJsonText);
                if (receivedJson instanceof JSONObject) {
                    this.validateJson("$.", (JSONObject)receivedJson, (JSONObject)controlJson, validationContext, context, (ReadContext)readContext);
                    break block9;
                }
                if (receivedJson instanceof JSONArray) {
                    JSONObject tempReceived = new JSONObject();
                    tempReceived.put((Object)"array", receivedJson);
                    JSONObject tempControl = new JSONObject();
                    tempControl.put((Object)"array", controlJson);
                    this.validateJson("$.", tempReceived, tempControl, validationContext, context, (ReadContext)readContext);
                    break block9;
                }
                throw new CitrusRuntimeException("Unsupported json type " + receivedJson.getClass());
            }
            catch (IllegalArgumentException e) {
                throw new ValidationException(String.format("Failed to validate JSON text:%n%s", receivedJsonText), (Throwable)e);
            }
            catch (ParseException e) {
                throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
            }
        }
        logger.info("JSON message validation successful: All values OK");
    }

    private List<JsonSchemaRepository> findSchemaRepositories(TestContext context) {
        return new ArrayList<JsonSchemaRepository>(context.getReferenceResolver().resolveAll(JsonSchemaRepository.class).values());
    }

    public void validateJson(String elementName, JSONObject receivedJson, JSONObject controlJson, JsonMessageValidationContext validationContext, TestContext context, ReadContext readContext) {
        if (this.strict && controlJson.size() != receivedJson.size()) {
            throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Number of JSON entries not equal for element: '" + elementName + "'"), (Object)controlJson.size(), (Object)receivedJson.size()));
        }
        for (Map.Entry controlJsonEntry : controlJson.entrySet()) {
            Object receivedValue;
            String controlKey = (String)controlJsonEntry.getKey();
            if (!receivedJson.containsKey((Object)controlKey)) {
                throw new ValidationException("Missing JSON entry: + '" + controlKey + "'");
            }
            Object controlValue = controlJsonEntry.getValue();
            if (this.isIgnored(controlKey, controlValue, receivedValue = receivedJson.get((Object)controlKey), validationContext.getIgnoreExpressions(), readContext)) continue;
            if (controlValue == null) {
                if (receivedValue != null) {
                    throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry: '" + controlKey + "'"), null, (Object)receivedValue));
                }
            } else if (receivedValue != null) {
                if (ValidationMatcherUtils.isValidationMatcherExpression((String)controlValue.toString())) {
                    ValidationMatcherUtils.resolveValidationMatcher((String)controlKey, (String)receivedValue.toString(), (String)controlValue.toString(), (TestContext)context);
                } else if (controlValue instanceof JSONObject) {
                    if (!(receivedValue instanceof JSONObject)) {
                        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Type mismatch for JSON entry '" + controlKey + "'"), (Object)JSONObject.class.getSimpleName(), (Object)receivedValue.getClass().getSimpleName()));
                    }
                    this.validateJson(controlKey, (JSONObject)receivedValue, (JSONObject)controlValue, validationContext, context, readContext);
                } else if (controlValue instanceof JSONArray) {
                    if (!(receivedValue instanceof JSONArray)) {
                        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Type mismatch for JSON entry '" + controlKey + "'"), (Object)JSONArray.class.getSimpleName(), (Object)receivedValue.getClass().getSimpleName()));
                    }
                    JSONArray jsonArrayControl = (JSONArray)controlValue;
                    JSONArray jsonArrayReceived = (JSONArray)receivedValue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Validating JSONArray containing " + jsonArrayControl.size() + " entries");
                    }
                    if (this.strict && jsonArrayControl.size() != jsonArrayReceived.size()) {
                        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("JSONArray size mismatch for JSON entry '" + controlKey + "'"), (Object)jsonArrayControl.size(), (Object)jsonArrayReceived.size()));
                    }
                    for (int i = 0; i < jsonArrayControl.size(); ++i) {
                        if (jsonArrayControl.get(i).getClass().isAssignableFrom(JSONObject.class)) {
                            if (!jsonArrayReceived.get(i).getClass().isAssignableFrom(JSONObject.class)) {
                                throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Value types not equal for entry: '" + jsonArrayControl.get(i) + "'"), (Object)JSONObject.class.getName(), (Object)jsonArrayReceived.get(i).getClass().getName()));
                            }
                            this.validateJson(controlKey, (JSONObject)jsonArrayReceived.get(i), (JSONObject)jsonArrayControl.get(i), validationContext, context, readContext);
                            continue;
                        }
                        if (jsonArrayControl.get(i).equals(jsonArrayReceived.get(i))) continue;
                        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry: '" + jsonArrayControl.get(i) + "'"), (Object)jsonArrayControl.get(i), (Object)jsonArrayReceived.get(i)));
                    }
                } else if (!controlValue.equals(receivedValue)) {
                    throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry: '" + controlKey + "'"), controlValue, (Object)receivedValue));
                }
            } else if (ValidationMatcherUtils.isValidationMatcherExpression((String)controlValue.toString())) {
                ValidationMatcherUtils.resolveValidationMatcher((String)controlKey, null, (String)controlValue.toString(), (TestContext)context);
            } else if (StringUtils.hasText((String)controlValue.toString())) {
                throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry '" + controlKey + "'"), (Object)controlValue.toString(), null));
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Validation successful for JSON entry '" + controlKey + "' (" + controlValue + ")");
        }
    }

    public boolean isIgnored(String controlKey, Object controlValue, Object receivedJson, Set<String> ignoreExpressions, ReadContext readContext) {
        if (controlValue != null && controlValue.toString().trim().equals("@ignore@")) {
            if (logger.isDebugEnabled()) {
                logger.debug("JSON entry: '" + controlKey + "' is ignored by placeholder '@ignore@'");
            }
            return true;
        }
        for (String jsonPathExpression : ignoreExpressions) {
            Object foundEntry = readContext.read(jsonPathExpression, new Predicate[0]);
            if (foundEntry instanceof JSONArray && ((JSONArray)foundEntry).contains(receivedJson)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("JSON entry: '" + controlKey + "' is ignored - skip value validation");
                }
                return true;
            }
            if (foundEntry == null || !foundEntry.equals(receivedJson)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("JSON entry: '" + controlKey + "' is ignored - skip value validation");
            }
            return true;
        }
        return false;
    }

    protected Class<JsonMessageValidationContext> getRequiredValidationContextType() {
        return JsonMessageValidationContext.class;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.JSON.name()) && MessageUtils.hasJsonPayload((Message)message);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public JsonTextMessageValidator strict(boolean strict) {
        this.setStrict(strict);
        return this;
    }

    void setJsonSchemaValidation(JsonSchemaValidation jsonSchemaValidation) {
        this.jsonSchemaValidation = jsonSchemaValidation;
    }

    public JsonTextMessageValidator jsonSchemaValidation(JsonSchemaValidation jsonSchemaValidation) {
        this.setJsonSchemaValidation(jsonSchemaValidation);
        return this;
    }

    public void setPermissiveMode(int permissiveMode) {
        this.permissiveMode = permissiveMode;
    }

    public JsonTextMessageValidator permissiveMode(int permissiveMode) {
        this.setPermissiveMode(permissiveMode);
        return this;
    }
}

