/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.json.JsonSchemaRepository;
import org.citrusframework.json.schema.SimpleJsonSchema;
import org.citrusframework.message.Message;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.validation.SchemaValidator;
import org.citrusframework.validation.json.JsonMessageValidationContext;
import org.citrusframework.validation.json.report.GraciousProcessingReport;
import org.citrusframework.validation.json.schema.JsonSchemaFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidation
implements SchemaValidator<JsonMessageValidationContext> {
    private Logger log = LoggerFactory.getLogger(JsonSchemaValidation.class);
    private final JsonSchemaFilter jsonSchemaFilter;
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonSchemaValidation() {
        this(new JsonSchemaFilter());
    }

    public JsonSchemaValidation(JsonSchemaFilter jsonSchemaFilter) {
        this.jsonSchemaFilter = jsonSchemaFilter;
    }

    public void validate(Message message, TestContext context, JsonMessageValidationContext validationContext) {
        this.log.debug("Starting Json schema validation ...");
        GraciousProcessingReport report = this.validate(message, this.findSchemaRepositories(context), validationContext, context.getReferenceResolver());
        if (!report.isSuccess()) {
            this.log.error("Failed to validate Json schema for message:\n" + (String)message.getPayload(String.class));
            throw new ValidationException(this.constructErrorMessage(report));
        }
        this.log.info("Json schema validation successful: All values OK");
    }

    private String constructErrorMessage(GraciousProcessingReport report) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Json validation failed: ");
        report.getValidationMessages().forEach(processingMessage -> stringBuilder.append("\n\t").append(processingMessage.getMessage()));
        return stringBuilder.toString();
    }

    private List<JsonSchemaRepository> findSchemaRepositories(TestContext context) {
        return new ArrayList<JsonSchemaRepository>(context.getReferenceResolver().resolveAll(JsonSchemaRepository.class).values());
    }

    public GraciousProcessingReport validate(Message message, List<JsonSchemaRepository> schemaRepositories, JsonMessageValidationContext validationContext, ReferenceResolver referenceResolver) {
        return this.validate(message, this.jsonSchemaFilter.filter(schemaRepositories, validationContext, referenceResolver));
    }

    private GraciousProcessingReport validate(Message message, List<SimpleJsonSchema> jsonSchemas) {
        if (jsonSchemas.isEmpty()) {
            return new GraciousProcessingReport(true);
        }
        GraciousProcessingReport processingReport = new GraciousProcessingReport();
        for (SimpleJsonSchema simpleJsonSchema : jsonSchemas) {
            processingReport.mergeWith(this.validate(message, simpleJsonSchema));
        }
        return processingReport;
    }

    private Set<ValidationMessage> validate(Message message, SimpleJsonSchema simpleJsonSchema) {
        try {
            JsonNode receivedJson = this.objectMapper.readTree((String)message.getPayload(String.class));
            if (receivedJson.isEmpty()) {
                return Collections.emptySet();
            }
            return simpleJsonSchema.getSchema().validate(this.objectMapper.readTree((String)message.getPayload(String.class)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to validate Json schema", (Throwable)e);
        }
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return "JSON".equals(messageType) || message != null && IsJsonPredicate.getInstance().test((String)message.getPayload(String.class));
    }
}

