/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.json.JsonPathUtils;
import org.citrusframework.message.Message;
import org.citrusframework.variable.VariableExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class JsonPathVariableExtractor
implements VariableExtractor {
    private final Map<String, Object> jsonPathExpressions;
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathVariableExtractor.class);

    public JsonPathVariableExtractor() {
        this(new Builder());
    }

    private JsonPathVariableExtractor(Builder builder) {
        this.jsonPathExpressions = builder.expressions;
    }

    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.jsonPathExpressions)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading JSON elements with JSONPath");
        }
        try {
            JSONParser parser = new JSONParser(4032);
            Object receivedJson = parser.parse((String)message.getPayload(String.class));
            DocumentContext readerContext = JsonPath.parse((Object)receivedJson);
            for (Map.Entry<String, Object> entry : this.jsonPathExpressions.entrySet()) {
                Object jsonPathResult;
                String jsonPathExpression = context.replaceDynamicContentInString(entry.getKey());
                String variableName = Optional.ofNullable(entry.getValue()).map(Object::toString).orElseThrow(() -> new CitrusRuntimeException(String.format("Variable name must be set on extractor path expression '%s'", jsonPathExpression)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Evaluating JSONPath expression: " + jsonPathExpression);
                }
                if ((jsonPathResult = JsonPathUtils.evaluate((ReadContext)readerContext, jsonPathExpression)) instanceof JSONArray) {
                    context.setVariable(variableName, (Object)((JSONArray)jsonPathResult).toJSONString());
                    continue;
                }
                if (jsonPathResult instanceof JSONObject) {
                    context.setVariable(variableName, (Object)((JSONObject)jsonPathResult).toJSONString());
                    continue;
                }
                context.setVariable(variableName, Optional.ofNullable(jsonPathResult).orElse("null"));
            }
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
        }
    }

    public Map<String, Object> getJsonPathExpressions() {
        return this.jsonPathExpressions;
    }

    public static final class Builder
    implements VariableExtractor.Builder<JsonPathVariableExtractor, Builder> {
        private final Map<String, Object> expressions = new LinkedHashMap<String, Object>();

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object variableName) {
            this.expressions.put(expression, variableName);
            return this;
        }

        public JsonPathVariableExtractor build() {
            return new JsonPathVariableExtractor(this);
        }
    }
}

