/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.selector;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.json.JsonPathUtils;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageSelector;
import org.citrusframework.message.selector.AbstractMessageSelector;
import org.springframework.util.StringUtils;

public class JsonPathPayloadMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_PREFIX = "jsonPath:";

    public JsonPathPayloadMessageSelector(String expression, String control, TestContext context) {
        super(expression.substring(SELECTOR_PREFIX.length()), control, context);
    }

    public boolean accept(Message message) {
        String payload = this.getPayloadAsString(message);
        if (StringUtils.hasText((String)payload) && !payload.trim().startsWith("{") && !payload.trim().startsWith("[")) {
            return false;
        }
        try {
            return this.evaluate(JsonPathUtils.evaluateAsString(payload, this.selectKey));
        }
        catch (CitrusRuntimeException e) {
            return false;
        }
    }

    public static class Factory
    implements MessageSelector.MessageSelectorFactory {
        public boolean supports(String key) {
            return key.startsWith(JsonPathPayloadMessageSelector.SELECTOR_PREFIX);
        }

        public JsonPathPayloadMessageSelector create(String key, String value, TestContext context) {
            return new JsonPathPayloadMessageSelector(key, value, context);
        }
    }
}

