/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.hamcrest;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.matcher.ControlExpressionParser;
import org.citrusframework.validation.matcher.DefaultControlExpressionParser;
import org.citrusframework.validation.matcher.ValidationMatcher;
import org.citrusframework.validation.matcher.hamcrest.HamcrestMatcherProvider;
import org.citrusframework.variable.VariableUtils;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class HamcrestValidationMatcher
implements ValidationMatcher,
ControlExpressionParser {
    private final List<String> matchers = Arrays.asList("equalTo", "equalToIgnoringCase", "equalToIgnoringWhiteSpace", "is", "not", "containsString", "startsWith", "endsWith", "matchesPattern");
    private final List<String> collectionMatchers = Arrays.asList("hasSize", "hasItem", "hasItems", "contains", "containsInAnyOrder");
    private final List<String> mapMatchers = Arrays.asList("hasEntry", "hasKey", "hasValue");
    private final List<String> optionMatchers = Arrays.asList("isOneOf", "isIn");
    private final List<String> numericMatchers = Arrays.asList("greaterThan", "greaterThanOrEqualTo", "lessThan", "lessThanOrEqualTo", "closeTo");
    private final List<String> containerMatchers = Arrays.asList("is", "not", "everyItem");
    private final List<String> noArgumentMatchers = Arrays.asList("isEmptyString", "isEmptyOrNullString", "nullValue", "notNullValue", "anything");
    private final List<String> noArgumentCollectionMatchers = Collections.singletonList("empty");
    private final List<String> iterableMatchers = Arrays.asList("anyOf", "allOf");

    public void validate(String fieldName, String value, List<String> controlParameters, TestContext context) throws ValidationException {
        String matcherExpression;
        String matcherValue = value;
        if (controlParameters.size() > 1) {
            matcherValue = context.replaceDynamicContentInString(controlParameters.get(0));
            matcherExpression = controlParameters.get(1);
        } else {
            matcherExpression = controlParameters.get(0);
        }
        String matcherName = matcherExpression.trim().substring(0, matcherExpression.trim().indexOf("("));
        String[] matcherParameter = this.determineNestedMatcherParameters(matcherExpression.trim().substring(matcherName.length() + 1, matcherExpression.trim().length() - 1));
        try {
            org.hamcrest.Matcher<?> matcher = this.getMatcher(matcherName, matcherParameter, context);
            if (this.noArgumentCollectionMatchers.contains(matcherName) || this.collectionMatchers.contains(matcherName) || matcherName.equals("everyItem")) {
                MatcherAssert.assertThat(this.getCollection(matcherValue), matcher);
            } else if (this.mapMatchers.contains(matcherName)) {
                MatcherAssert.assertThat(this.getMap(matcherValue), matcher);
            } else if (this.numericMatchers.contains(matcherName)) {
                if (matcherName.equals("closeTo")) {
                    MatcherAssert.assertThat((Object)Double.valueOf(matcherValue), matcher);
                } else {
                    MatcherAssert.assertThat((Object)new NumericComparable(matcherValue), matcher);
                }
            } else if (this.iterableMatchers.contains(matcherName) && this.containsNumericMatcher(matcherExpression)) {
                MatcherAssert.assertThat((Object)new NumericComparable(matcherValue), matcher);
            } else {
                MatcherAssert.assertThat((Object)matcherValue, matcher);
            }
        }
        catch (AssertionError e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received value is '" + value + "' and did not match '" + matcherExpression + "'.", (Throwable)((Object)e));
        }
    }

    private org.hamcrest.Matcher<?> getMatcher(String matcherName, String[] matcherParameter, TestContext context) {
        try {
            String matcherExpression;
            Method matcherMethod;
            Optional<HamcrestMatcherProvider> matcherProvider;
            if ((context.getReferenceResolver().isResolvable(matcherName, HamcrestMatcherProvider.class) || HamcrestMatcherProvider.canResolve(matcherName)) && (matcherProvider = this.lookupMatcherProvider(matcherName, context)).isPresent()) {
                return matcherProvider.get().provideMatcher(matcherParameter[0]);
            }
            if (this.noArgumentMatchers.contains(matcherName) && (matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[0])) != null) {
                return (org.hamcrest.Matcher)matcherMethod.invoke(null, new Object[0]);
            }
            if (this.noArgumentCollectionMatchers.contains(matcherName) && (matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[0])) != null) {
                return (org.hamcrest.Matcher)matcherMethod.invoke(null, new Object[0]);
            }
            if (matcherParameter.length == 0) {
                throw new CitrusRuntimeException("Missing matcher parameter");
            }
            if (this.containerMatchers.contains(matcherName) && (matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{org.hamcrest.Matcher.class})) != null && (matcherExpression = matcherParameter[0]).contains("(") && matcherExpression.contains(")")) {
                String nestedMatcherName = matcherExpression.trim().substring(0, matcherExpression.trim().indexOf("("));
                String[] nestedMatcherParameter = matcherExpression.trim().substring(nestedMatcherName.length() + 1, matcherExpression.trim().length() - 1).split(",");
                return (org.hamcrest.Matcher)matcherMethod.invoke(null, this.getMatcher(nestedMatcherName, nestedMatcherParameter, context));
            }
            if (this.iterableMatchers.contains(matcherName) && (matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Iterable.class})) != null) {
                ArrayList nestedMatchers = new ArrayList();
                for (String matcherExpression2 : matcherParameter) {
                    String nestedMatcherName = matcherExpression2.trim().substring(0, matcherExpression2.trim().indexOf("("));
                    String[] nestedMatcherParameters = this.determineNestedMatcherParameters(matcherExpression2.trim().substring(nestedMatcherName.length() + 1, matcherExpression2.trim().length() - 1));
                    nestedMatchers.add(this.getMatcher(nestedMatcherName, nestedMatcherParameters, context));
                }
                return (org.hamcrest.Matcher)matcherMethod.invoke(null, nestedMatchers);
            }
            if (this.matchers.contains(matcherName)) {
                HamcrestValidationMatcher.unescapeQuotes(matcherParameter);
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{String.class});
                if (matcherMethod == null) {
                    matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class});
                }
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
            }
            if (this.numericMatchers.contains(matcherName)) {
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Double.TYPE, Double.TYPE});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, Double.valueOf(matcherParameter[0]), matcherParameter.length > 1 ? Double.parseDouble(matcherParameter[1]) : 0.0);
                }
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Comparable.class});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
            }
            if (this.collectionMatchers.contains(matcherName)) {
                HamcrestValidationMatcher.unescapeQuotes(matcherParameter);
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Integer.TYPE});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, Integer.valueOf(matcherParameter[0]));
                }
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object[].class});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, new Object[]{matcherParameter});
                }
            }
            if (this.mapMatchers.contains(matcherName)) {
                HamcrestValidationMatcher.unescapeQuotes(matcherParameter);
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, matcherParameter[0]);
                }
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object.class, Object.class});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, matcherParameter[0], matcherParameter[1]);
                }
            }
            if (this.optionMatchers.contains(matcherName)) {
                HamcrestValidationMatcher.unescapeQuotes(matcherParameter);
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Object[].class});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, new Object[]{matcherParameter});
                }
                matcherMethod = ReflectionHelper.findMethod(Matchers.class, (String)matcherName, (Class[])new Class[]{Collection.class});
                if (matcherMethod != null) {
                    return (org.hamcrest.Matcher)matcherMethod.invoke(null, this.getCollection(String.join((CharSequence)",", matcherParameter)));
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CitrusRuntimeException("Failed to invoke matcher", (Throwable)e);
        }
        throw new CitrusRuntimeException("Unsupported matcher: " + matcherName);
    }

    private static void unescapeQuotes(String[] matcherParameters) {
        if (matcherParameters != null) {
            for (int i = 0; i < matcherParameters.length; ++i) {
                matcherParameters[i] = matcherParameters[i].replace("\\'", "'");
            }
        }
    }

    private Optional<HamcrestMatcherProvider> lookupMatcherProvider(String matcherName, TestContext context) {
        Optional<HamcrestMatcherProvider> matcherProvider = context.getReferenceResolver().resolveAll(HamcrestMatcherProvider.class).values().stream().filter(provider -> provider.getName().equals(matcherName)).findFirst();
        if (!matcherProvider.isPresent()) {
            matcherProvider = HamcrestMatcherProvider.lookup(matcherName);
        }
        return matcherProvider;
    }

    private List<String> getCollection(String value) {
        if (value.equals("[]")) {
            return Collections.emptyList();
        }
        String arrayString = value;
        if (arrayString.startsWith("[") && arrayString.endsWith("]")) {
            arrayString = arrayString.substring(1, arrayString.length() - 1);
        }
        return Arrays.stream(arrayString.split(",")).map(String::trim).map(VariableUtils::cutOffDoubleQuotes).filter(StringUtils::hasText).collect(Collectors.toList());
    }

    private Map<String, Object> getMap(String mapString) {
        Properties props = new Properties();
        try {
            props.load(new StringReader(mapString.substring(1, mapString.length() - 1).replaceAll(",\\s*", "\n")));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to reconstruct object of type map", (Throwable)e);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey() instanceof String ? VariableUtils.cutOffDoubleQuotes((String)entry.getKey().toString()) : entry.getKey().toString();
            Object value = entry.getValue() instanceof String ? VariableUtils.cutOffDoubleQuotes((String)entry.getValue().toString()).trim() : entry.getValue();
            map.put(key, value);
        }
        return map;
    }

    private boolean containsNumericMatcher(String matcherExpression) {
        for (String numericMatcher : this.numericMatchers) {
            if (!matcherExpression.contains(numericMatcher)) continue;
            return true;
        }
        return false;
    }

    public List<String> extractControlValues(String controlExpression, Character delimiter) {
        if (controlExpression.startsWith("'") && controlExpression.contains("',")) {
            return new DefaultControlExpressionParser().extractControlValues(controlExpression, delimiter);
        }
        return Collections.singletonList(controlExpression);
    }

    public String[] determineNestedMatcherParameters(String rawExpression) {
        if (!StringUtils.hasText((String)rawExpression)) {
            return new String[0];
        }
        Tokenizer tokenizer = new Tokenizer();
        String tokenizedExpression = tokenizer.tokenize(rawExpression);
        return tokenizer.restoreInto(tokenizedExpression.split(","));
    }

    private static class NumericComparable
    implements Comparable<Object> {
        private Long number = null;
        private Double decimal = null;

        public NumericComparable(String value) {
            if (value.contains(".")) {
                this.decimal = Double.parseDouble(value);
            } else {
                try {
                    this.number = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        @Override
        public int compareTo(Object o) {
            if (this.number != null) {
                if (o instanceof String || o instanceof NumericComparable) {
                    return this.number.compareTo(Long.parseLong(o.toString()));
                }
                if (o instanceof Long) {
                    return this.number.compareTo((Long)o);
                }
            }
            if (this.decimal != null) {
                if (o instanceof String || o instanceof NumericComparable) {
                    return this.decimal.compareTo(Double.parseDouble(o.toString()));
                }
                if (o instanceof Double) {
                    return this.decimal.compareTo((Double)o);
                }
            }
            return 0;
        }

        public String toString() {
            if (this.number != null) {
                return this.number.toString();
            }
            return this.decimal.toString();
        }
    }

    private static class Tokenizer {
        private static final String START_TOKEN = "_TOKEN-";
        private static final String END_TOKEN = "-TOKEN_";
        private static final Pattern TEXT_PARAMETER_PATTERN = Pattern.compile("(?<quoted1>\\('(?:[^']|\\\\')*[^\\\\]'\\))|(?<quoted2>('(?:[^']|\\\\')*[^\\\\]'))|(?<unquoted>\\(((?:[^']|\\\\')*?)[^\\\\]?\\))");
        private final List<String> originalTokenValues = new ArrayList<String>();

        private Tokenizer() {
        }

        public String tokenize(String rawExpression) {
            Matcher matcher = TEXT_PARAMETER_PATTERN.matcher(rawExpression);
            StringBuilder builder = new StringBuilder();
            while (matcher.find()) {
                String matchedValue = this.findMatchedValue(matcher);
                this.originalTokenValues.add(matchedValue);
                matcher.appendReplacement(builder, START_TOKEN + this.originalTokenValues.size() + END_TOKEN);
            }
            matcher.appendTail(builder);
            return builder.toString();
        }

        private String findMatchedValue(Matcher matcher) {
            String matchedValue = matcher.group("quoted1");
            matchedValue = matchedValue != null ? matchedValue : matcher.group("quoted2");
            return matchedValue != null ? matchedValue : matcher.group("unquoted");
        }

        public String[] restoreInto(String[] expressions) {
            for (int i = 0; i < expressions.length; ++i) {
                expressions[i] = VariableUtils.cutOffSingleQuotes((String)this.replaceTokens(expressions[i], this.originalTokenValues).trim());
            }
            return expressions;
        }

        private String replaceTokens(String expression, List<String> params) {
            for (int i = 0; i < params.size(); ++i) {
                expression = expression.replace(START_TOKEN + (i + 1) + END_TOKEN, params.get(i));
            }
            return expression;
        }
    }
}

