/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.script.sql;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.script.GroovyScriptMessageValidator;
import org.citrusframework.validation.script.ScriptValidationContext;
import org.citrusframework.validation.script.TemplateBasedScriptBuilder;
import org.citrusframework.validation.script.sql.SqlResultSetScriptExecutor;
import org.citrusframework.validation.script.sql.SqlResultSetScriptValidator;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovySqlResultSetValidator
implements SqlResultSetScriptValidator {
    private static final Logger logger = LoggerFactory.getLogger(GroovySqlResultSetValidator.class);
    private final Resource scriptTemplateResource;

    public GroovySqlResultSetValidator() {
        this(Resources.fromClasspath((String)"org/citrusframework/validation/sql/sql-validation-template.groovy"));
    }

    public GroovySqlResultSetValidator(Resource scriptTemplateResource) {
        this.scriptTemplateResource = scriptTemplateResource;
    }

    public void validateSqlResultSet(List<Map<String, Object>> resultSet, ScriptValidationContext validationContext, TestContext context) throws ValidationException {
        block12: {
            if (validationContext.getScriptType().equals("groovy")) {
                try {
                    String validationScript = validationContext.getValidationScript(context);
                    if (!StringUtils.hasText((String)validationScript)) break block12;
                    logger.debug("Start groovy SQL result set validation");
                    try (GroovyClassLoader loader = new GroovyClassLoader(GroovyScriptMessageValidator.class.getClassLoader());){
                        Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource((Resource)this.scriptTemplateResource).withCode(validationScript).build());
                        if (groovyClass == null) {
                            throw new CitrusRuntimeException("Failed to load groovy validation script resource");
                        }
                        GroovyObject groovyObject = (GroovyObject)groovyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        ((SqlResultSetScriptExecutor)groovyObject).validate(resultSet, context);
                    }
                    catch (IOException e) {
                        throw new CitrusRuntimeException("Failed to load groovy validation script resource", (Throwable)e);
                    }
                    logger.debug("Groovy SQL result set validation successful: All values OK");
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CompilationFailedException e) {
                    throw new CitrusRuntimeException(e);
                }
                catch (AssertionError e) {
                    throw new ValidationException("Groovy SQL result set validation failed with assertion error:\n" + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
                }
            }
        }
    }
}

