/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.script;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.security.AccessController;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.AbstractMessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.script.GroovyScriptExecutor;
import org.citrusframework.validation.script.ScriptValidationContext;
import org.citrusframework.validation.script.TemplateBasedScriptBuilder;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyScriptMessageValidator
extends AbstractMessageValidator<ScriptValidationContext> {
    private static final Logger logger = LoggerFactory.getLogger(GroovyScriptMessageValidator.class);
    private final Resource scriptTemplateResource;

    public GroovyScriptMessageValidator() {
        this(Resources.fromClasspath((String)"org/citrusframework/validation/script-validation-template.groovy"));
    }

    public GroovyScriptMessageValidator(Resource scriptTemplateResource) {
        this.scriptTemplateResource = scriptTemplateResource;
    }

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ScriptValidationContext validationContext) throws ValidationException {
        try {
            String validationScript = validationContext.getValidationScript(context);
            if (StringUtils.hasText((String)validationScript)) {
                logger.debug("Start groovy message validation ...");
                GroovyClassLoader loader = AccessController.doPrivileged(() -> new GroovyClassLoader(GroovyScriptMessageValidator.class.getClassLoader()));
                Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource((Resource)this.scriptTemplateResource).withCode(validationScript).build());
                if (groovyClass == null) {
                    throw new CitrusRuntimeException("Failed to load groovy validation script resource");
                }
                GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
                ((GroovyScriptExecutor)groovyObject).validate(receivedMessage, context);
                logger.debug("Groovy message validation successful: All values OK");
            }
        }
        catch (IllegalAccessException | InstantiationException | CompilationFailedException e) {
            throw new CitrusRuntimeException(e);
        }
        catch (AssertionError e) {
            throw new ValidationException("Groovy script validation failed with assertion error:\n" + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    public ScriptValidationContext findValidationContext(List<ValidationContext> validationContexts) {
        for (ValidationContext validationContext : validationContexts) {
            if (!this.getRequiredValidationContextType().isInstance(validationContext) || !((ScriptValidationContext)validationContext).getScriptType().equals("groovy")) continue;
            return (ScriptValidationContext)validationContext;
        }
        return null;
    }

    protected Class<ScriptValidationContext> getRequiredValidationContextType() {
        return ScriptValidationContext.class;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.PLAINTEXT.toString());
    }
}

