/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.binary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.validation.DefaultMessageValidator;
import org.citrusframework.validation.context.ValidationContext;

public class BinaryMessageValidator
extends DefaultMessageValidator {
    private static final int BUFFER_SIZE = 1024;

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) throws ValidationException {
        try (InputStream receivedInput = (InputStream)receivedMessage.getPayload(InputStream.class);
             InputStream controlInput = (InputStream)controlMessage.getPayload(InputStream.class);){
            logger.debug("Start binary message validation");
            ReadableByteChannel receivedBytes = Channels.newChannel(receivedInput);
            ReadableByteChannel controlBytes = Channels.newChannel(controlInput);
            ByteBuffer receivedBuffer = ByteBuffer.allocateDirect(1024);
            ByteBuffer controlBuffer = ByteBuffer.allocateDirect(1024);
            ByteArrayOutputStream receivedResult = new ByteArrayOutputStream();
            ByteArrayOutputStream controlResult = new ByteArrayOutputStream();
            while (true) {
                int n1 = receivedBytes.read(receivedBuffer);
                int n2 = controlBytes.read(controlBuffer);
                if (n1 == -1 && n2 == -1) {
                    logger.debug("Binary message validation successful: All values OK");
                    return;
                }
                if (n1 == -1) {
                    throw new ValidationException("Received input stream reached end-of-stream - control input stream is not finished yet");
                }
                if (n2 == -1) {
                    throw new ValidationException("Control input stream reached end-of-stream - received input stream is not finished yet");
                }
                receivedBuffer.flip();
                controlBuffer.flip();
                for (int i = 0; i < Math.min(n1, n2); ++i) {
                    byte received = receivedBuffer.get();
                    byte control = controlBuffer.get();
                    receivedResult.write((char)received);
                    controlResult.write((char)control);
                    if (received == control) continue;
                    logger.info("Received input stream is not equal - expected '%s', but was '%s'".formatted(controlResult.toString(), receivedResult.toString()));
                    throw new ValidationException("Received input stream is not equal to given control, expected '%s', but was '%s'".formatted(controlResult.toString().substring(controlResult.toString().length() - Math.min(25, controlResult.size())), receivedResult.toString().substring(receivedResult.toString().length() - Math.min(25, receivedResult.size()))));
                }
                receivedBuffer.compact();
                controlBuffer.compact();
            }
        }
        catch (IOException e) {
            throw new ValidationException("Failed to compare binary input streams", (Throwable)e);
        }
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.BINARY.toString());
    }
}

