/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.testng.spring;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.CitrusContextProvider;
import org.citrusframework.CitrusSpringContext;
import org.citrusframework.CitrusSpringContextProvider;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestBehavior;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestGroupAware;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusTest;
import org.citrusframework.annotations.CitrusTestSource;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.common.TestSourceHelper;
import org.citrusframework.config.CitrusSpringConfig;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.testng.TestNGHelper;
import org.citrusframework.testng.spring.TestNGCitrusSpringMethodInterceptor;
import org.citrusframework.util.ObjectHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.IHookCallBack;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Listeners;

@Listeners(value={TestNGCitrusSpringMethodInterceptor.class})
@ContextConfiguration(classes={CitrusSpringConfig.class})
public class TestNGCitrusSpringSupport
extends AbstractTestNGSpringContextTests
implements GherkinTestActionRunner {
    protected Citrus citrus;
    private TestCaseRunner delegate;
    private TestCase testCase;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method == null) {
            super.run(callBack, testResult);
            return;
        }
        List<TestLoader> methodTestLoaders = TestNGHelper.createMethodTestLoaders(method, this::createTestLoader);
        if (method.getAnnotation(CitrusTest.class) != null || method.getAnnotation(CitrusTestSource.class) != null) {
            try {
                this.run(testResult, method, methodTestLoaders, testResult.getMethod().getCurrentInvocationCount());
                testResult.setStatus(1);
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            super.run((IHookCallBack)new TestNGHelper.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                Throwable throwable = testResult.getThrowable();
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            super.run(callBack, testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ITestResult testResult, Method method, List<TestLoader> methodTestLoaders, int invocationCount) {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
            CitrusAnnotations.injectCitrusFramework((Object)((Object)this), (Citrus)this.citrus);
        }
        try {
            DefaultTestLoader testLoader;
            TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
            TestCaseRunner runner = TestNGHelper.createTestCaseRunner((Object)this, method, ctx);
            runner.groups(testResult.getMethod().getGroups());
            testResult.setAttribute("builder", (Object)runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)((Object)this), (Citrus)this.citrus, (TestContext)ctx);
            if (method.getAnnotation(CitrusTestSource.class) != null && !methodTestLoaders.isEmpty()) {
                testLoader = methodTestLoaders.get(invocationCount % methodTestLoaders.size());
                if (testLoader instanceof TestSourceAware) {
                    TestSourceAware testSourceAware = (TestSourceAware)testLoader;
                    String[] sources = method.getAnnotation(CitrusTestSource.class).sources();
                    if (sources.length > 0) {
                        testSourceAware.setSource(TestSourceHelper.create((String)sources[0]));
                    }
                }
            } else {
                testLoader = new DefaultTestLoader();
            }
            CitrusAnnotations.injectAll((Object)testLoader, (Citrus)this.citrus, (TestContext)ctx);
            CitrusAnnotations.injectTestRunner((Object)testLoader, (TestCaseRunner)runner);
            testLoader.configureTestCase(t -> {
                if (t instanceof TestGroupAware) {
                    TestGroupAware testGroupAware = (TestGroupAware)t;
                    testGroupAware.setGroups(testResult.getMethod().getGroups());
                }
            });
            testLoader.configureTestCase(t -> {
                this.testCase = t;
            });
            TestNGHelper.invokeTestMethod((Object)this, testResult, method, (TestLoader)testLoader, ctx, invocationCount);
        }
        finally {
            testResult.removeAttribute("builder");
        }
    }

    @BeforeClass(alwaysRun=true)
    public final void before() {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
            CitrusAnnotations.injectCitrusFramework((Object)((Object)this), (Citrus)this.citrus);
        }
        this.before(this.citrus.getCitrusContext());
    }

    protected void before(CitrusContext context) {
    }

    @AfterClass(alwaysRun=true)
    public final void after() {
        if (this.citrus != null) {
            this.after(this.citrus.getCitrusContext());
        }
    }

    protected void after(CitrusContext context) {
    }

    @BeforeSuite(alwaysRun=true)
    public final void beforeSuite() {
        try {
            this.springTestContextPrepareTestInstance();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to initialize Spring test context", (Throwable)e);
        }
        ObjectHelper.assertNotNull((Object)this.applicationContext, (String)"Missing proper application context in before suite initialization");
        this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
        CitrusAnnotations.injectCitrusFramework((Object)((Object)this), (Citrus)this.citrus);
        this.beforeSuite(this.citrus.getCitrusContext());
        this.citrus.beforeSuite(Reporter.getCurrentTestResult().getTestContext().getSuite().getName(), Reporter.getCurrentTestResult().getTestContext().getIncludedGroups());
    }

    protected void beforeSuite(CitrusContext context) {
    }

    @AfterSuite(alwaysRun=true)
    public final void afterSuite() {
        if (this.citrus != null) {
            this.afterSuite(this.citrus.getCitrusContext());
            this.citrus.afterSuite(Reporter.getCurrentTestResult().getTestContext().getSuite().getName(), Reporter.getCurrentTestResult().getTestContext().getIncludedGroups());
        }
    }

    protected void afterSuite(CitrusContext context) {
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName, String type) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)type).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", type)));
        testLoader.setTestClass(((Object)((Object)this)).getClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        CitrusAnnotations.injectCitrusContext((Object)testLoader, (CitrusContext)Optional.ofNullable(this.citrus).map(Citrus::getCitrusContext).orElseGet(() -> CitrusSpringContext.create((ApplicationContext)this.applicationContext)));
        return testLoader;
    }

    protected TestCase getTestCase() {
        if (this.testCase != null) {
            return this.testCase;
        }
        if (this.delegate != null) {
            return this.delegate.getTestCase();
        }
        return null;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

