/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.testng;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.TestClass;
import org.citrusframework.TestSource;
import org.citrusframework.common.TestSourceHelper;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.AbstractTestEngine;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.main.scan.ClassPathTestScanner;
import org.citrusframework.main.scan.JarFileTestScanner;
import org.citrusframework.report.TestReporterSettings;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.testng.main.TestNGCitrusTest;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGEngine
extends AbstractTestEngine {
    private static final Logger logger = LoggerFactory.getLogger(TestNGEngine.class);
    private final List<ITestNGListener> listeners = new ArrayList<ITestNGListener>();

    public TestNGEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        TestNG testng = new TestNG();
        testng.setOutputDirectory(TestReporterSettings.getReportDirectory() + "/test-output");
        for (ITestNGListener listener : this.listeners) {
            testng.addListener(listener);
        }
        XmlSuite suite = new XmlSuite();
        testng.setXmlSuites(Collections.singletonList(suite));
        if (this.getConfiguration().getTestSources().isEmpty()) {
            this.addTestPackages(suite, this.getConfiguration());
        } else {
            this.addTestClasses(suite, this.getConfiguration());
            this.addTestSources(suite, this.getConfiguration().getTestSources());
        }
        testng.run();
    }

    private void addTestSources(XmlSuite suite, List<TestSource> testSources) {
        List<TestSource> directories = testSources.stream().filter(source -> "directory".equals(source.getType())).toList();
        for (TestSource directory : directories) {
            Resource sourceDir = Resources.create((String)directory.getFilePath());
            if (!sourceDir.exists()) continue;
            if (sourceDir instanceof Resources.ClasspathResource) {
                try {
                    this.addTestSources(suite, new ClasspathResourceResolver().getResources(sourceDir.getLocation()).stream().map(Path::toString).map(TestSourceHelper::create).collect(Collectors.toList()));
                    continue;
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to resolve files from resource directory '%s'".formatted(sourceDir.getLocation()), (Throwable)e);
                }
            }
            this.addTestSources(suite, Optional.ofNullable(sourceDir.getFile().list()).stream().flatMap(Arrays::stream).map(file -> directory.getFilePath() + File.separator + file).map(TestSourceHelper::create).collect(Collectors.toList()));
        }
        List<TestSource> filtered = testSources.stream().filter(source -> !"directory".equals(source.getType())).filter(source -> !"java".equals(source.getType()) || !TestClass.isKnownToClasspath((String)source.getName())).toList();
        for (TestSource source2 : filtered) {
            logger.info(String.format("Running test source %s", source2.getName()));
            XmlTest test = new XmlTest(suite);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("name", source2.getName());
            if (StringUtils.hasText((String)source2.getFilePath())) {
                parameters.put("sourceFile", source2.getFilePath());
            } else if (source2.getSourceFile() != null) {
                parameters.put("sourceFile", source2.getSourceFile().getLocation());
            } else {
                parameters.put("sourceFile", "");
            }
            if (source2.getSourceFile() != null && source2.getSourceFile() instanceof Resources.ByteArrayResource) {
                try {
                    parameters.put("sourceContent", FileUtils.readToString((Resource)source2.getSourceFile()));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read test source content", (Throwable)e);
                }
            } else {
                parameters.put("sourceContent", "");
            }
            test.setParameters(parameters);
            XmlClass xmlClass = new XmlClass(TestNGCitrusTest.class);
            xmlClass.setIncludedMethods(Collections.singletonList(new XmlInclude("execute")));
            test.setClasses(Collections.singletonList(xmlClass));
        }
    }

    private void addTestPackages(XmlSuite suite, TestRunConfiguration configuration) {
        List<String> packagesToRun = configuration.getPackages();
        if (packagesToRun == null || packagesToRun.isEmpty()) {
            packagesToRun = Collections.singletonList("");
            logger.info("Running all tests in project");
        }
        for (String packageName : packagesToRun) {
            if (StringUtils.hasText((String)packageName)) {
                logger.info(String.format("Running tests in package %s", packageName));
            }
            XmlTest test = new XmlTest(suite);
            test.setClasses(new ArrayList());
            List classesToRun = configuration.getTestJar() != null ? new JarFileTestScanner(configuration.getTestJar(), configuration.getIncludes()).findTestsInPackage(packageName) : new ClassPathTestScanner(Test.class, configuration.getIncludes()).findTestsInPackage(packageName);
            classesToRun.stream().peek(testClass -> {
                Object[] objectArray = new Object[1];
                objectArray[0] = Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName());
                logger.info(String.format("Running test %s", objectArray));
            }).map(testClass -> {
                try {
                    Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                    return clazz;
                }
                catch (ClassNotFoundException | MalformedURLException e) {
                    logger.warn("Unable to read test class: " + testClass.getName());
                    return Void.class;
                }
            }).filter(clazz -> !clazz.equals(Void.class)).map(XmlClass::new).forEach(test.getClasses()::add);
            logger.info(String.format("Found %s test classes to execute", test.getClasses().size()));
        }
    }

    private void addTestClasses(XmlSuite suite, TestRunConfiguration configuration) {
        List<TestClass> testClasses = configuration.getTestSources().stream().filter(source -> "java".equals(source.getType())).map(TestSource::getName).filter(TestClass::isKnownToClasspath).map(TestClass::fromString).toList();
        for (TestClass testClass : testClasses) {
            Object[] objectArray = new Object[1];
            objectArray[0] = Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName());
            logger.info(String.format("Running test %s", objectArray));
            XmlTest test = new XmlTest(suite);
            test.setClasses(new ArrayList());
            try {
                Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                XmlClass xmlClass = new XmlClass(clazz);
                if (StringUtils.hasText((String)testClass.getMethod())) {
                    xmlClass.setIncludedMethods(Collections.singletonList(new XmlInclude(testClass.getMethod())));
                }
                test.getClasses().add(xmlClass);
            }
            catch (ClassNotFoundException | MalformedURLException e) {
                logger.warn("Unable to read test class: " + testClass.getName());
            }
        }
    }

    public TestNGEngine addTestListener(ITestNGListener listener) {
        this.listeners.add(listener);
        return this;
    }
}

