/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.testng;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestBehavior;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestGroupAware;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusTest;
import org.citrusframework.annotations.CitrusTestSource;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.common.TestSourceHelper;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.testng.TestNGCitrusMethodInterceptor;
import org.citrusframework.testng.TestNGHelper;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Listeners;

@Listeners(value={TestNGCitrusMethodInterceptor.class})
public class TestNGCitrusSupport
implements IHookable,
GherkinTestActionRunner {
    protected Citrus citrus;
    private TestCaseRunner delegate;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method == null) {
            callBack.runTestMethod(testResult);
            return;
        }
        List<TestLoader> methodTestLoaders = TestNGHelper.createMethodTestLoaders(method, this::createTestLoader);
        if (method.getAnnotation(CitrusTest.class) != null || method.getAnnotation(CitrusTestSource.class) != null) {
            try {
                this.run(testResult, method, methodTestLoaders, testResult.getMethod().getCurrentInvocationCount());
                testResult.setStatus(1);
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            callBack.runTestMethod(testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ITestResult testResult, Method method, List<TestLoader> methodTestLoaders, int invocationCount) {
        try {
            TestLoader testLoader;
            if (this.citrus == null) {
                this.citrus = Citrus.newInstance();
            }
            TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
            TestCaseRunner runner = TestNGHelper.createTestCaseRunner(this, method, ctx);
            runner.groups(testResult.getMethod().getGroups());
            testResult.setAttribute("builder", (Object)runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
            if (method.getAnnotation(CitrusTestSource.class) != null && !methodTestLoaders.isEmpty()) {
                String[] sources;
                testLoader = methodTestLoaders.get(invocationCount % methodTestLoaders.size());
                if (testLoader instanceof TestSourceAware && (sources = method.getAnnotation(CitrusTestSource.class).sources()).length > 0) {
                    ((TestSourceAware)testLoader).setSource(TestSourceHelper.create((String)sources[0]));
                }
            } else {
                testLoader = this.createTestLoader();
            }
            CitrusAnnotations.injectAll((Object)testLoader, (Citrus)this.citrus, (TestContext)ctx);
            CitrusAnnotations.injectTestRunner((Object)testLoader, (TestCaseRunner)runner);
            testLoader.configureTestCase(t -> {
                if (t instanceof TestGroupAware) {
                    ((TestGroupAware)t).setGroups(testResult.getMethod().getGroups());
                }
            });
            TestNGHelper.invokeTestMethod(this, testResult, method, testLoader, ctx, invocationCount);
        }
        finally {
            testResult.removeAttribute("builder");
        }
    }

    @BeforeClass(alwaysRun=true)
    public final void before() {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance();
            CitrusAnnotations.injectCitrusFramework((Object)this, (Citrus)this.citrus);
        }
        this.before(this.citrus.getCitrusContext());
    }

    protected void before(CitrusContext context) {
    }

    @AfterClass(alwaysRun=true)
    public final void after() {
        if (this.citrus != null) {
            this.after(this.citrus.getCitrusContext());
        }
    }

    protected void after(CitrusContext context) {
    }

    @BeforeSuite(alwaysRun=true)
    public final void beforeSuite() {
        this.citrus = Citrus.newInstance();
        CitrusAnnotations.injectCitrusFramework((Object)this, (Citrus)this.citrus);
        this.beforeSuite(this.citrus.getCitrusContext());
        this.citrus.beforeSuite(Reporter.getCurrentTestResult().getTestContext().getSuite().getName(), Reporter.getCurrentTestResult().getTestContext().getIncludedGroups());
    }

    protected void beforeSuite(CitrusContext context) {
    }

    @AfterSuite(alwaysRun=true)
    public final void afterSuite() {
        if (this.citrus != null) {
            this.afterSuite(this.citrus.getCitrusContext());
            this.citrus.afterSuite(Reporter.getCurrentTestResult().getTestContext().getSuite().getName(), Reporter.getCurrentTestResult().getTestContext().getIncludedGroups());
        }
    }

    protected void afterSuite(CitrusContext context) {
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName, String type) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)type).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", type)));
        testLoader.setTestClass(this.getClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        return testLoader;
    }

    protected TestLoader createTestLoader() {
        return new DefaultTestLoader();
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

