/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.testng.spring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.citrusframework.CitrusSettings;
import org.citrusframework.annotations.CitrusTestSource;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.testng.spring.TestNGCitrusSpringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.internal.MethodInstance;

public class TestNGCitrusSpringMethodInterceptor
implements IMethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TestNGCitrusSpringMethodInterceptor.class);

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        ArrayList<IMethodInstance> interceptedMethods = new ArrayList<IMethodInstance>();
        for (IMethodInstance method : methods) {
            boolean baseMethodAdded = false;
            if (method.getInstance() instanceof TestNGCitrusSpringSupport && method.getMethod().getConstructorOrMethod().getMethod().getAnnotation(CitrusTestSource.class) != null) {
                String[] packagesToScan;
                CitrusTestSource citrusTestAnnotation = method.getMethod().getConstructorOrMethod().getMethod().getAnnotation(CitrusTestSource.class);
                if (citrusTestAnnotation.name().length > 1) {
                    for (int i = 0; i < citrusTestAnnotation.name().length; ++i) {
                        if (i == 0) {
                            baseMethodAdded = true;
                            interceptedMethods.add(method);
                            continue;
                        }
                        interceptedMethods.add((IMethodInstance)new MethodInstance(method.getMethod()));
                    }
                }
                for (String packageName : packagesToScan = citrusTestAnnotation.packageScan()) {
                    try {
                        for (String fileNamePattern : CitrusSettings.getTestFileNamePattern((String)citrusTestAnnotation.type())) {
                            Set fileResources = new ClasspathResourceResolver().getResources(packageName.replace('.', File.separatorChar), fileNamePattern);
                            for (int i = 0; i < fileResources.size(); ++i) {
                                if (i == 0 && !baseMethodAdded) {
                                    baseMethodAdded = true;
                                    interceptedMethods.add(method);
                                    continue;
                                }
                                interceptedMethods.add((IMethodInstance)new MethodInstance(method.getMethod()));
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error("Unable to locate file resources for test package '" + packageName + "'", (Throwable)e);
                    }
                }
            }
            if (baseMethodAdded) continue;
            interceptedMethods.add(method);
        }
        return interceptedMethods;
    }
}

