/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.testng;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.citrusframework.TestClass;
import org.citrusframework.TestSource;
import org.citrusframework.main.AbstractTestEngine;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.main.scan.ClassPathTestScanner;
import org.citrusframework.main.scan.JarFileTestScanner;
import org.citrusframework.report.TestReporterSettings;
import org.citrusframework.testng.main.TestNGCitrusTest;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGEngine
extends AbstractTestEngine {
    private static final Logger logger = LoggerFactory.getLogger(TestNGEngine.class);
    private final List<ITestNGListener> listeners = new ArrayList<ITestNGListener>();

    public TestNGEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        TestNG testng = new TestNG();
        testng.setOutputDirectory(TestReporterSettings.getReportDirectory() + "/test-output");
        for (ITestNGListener listener : this.listeners) {
            testng.addListener(listener);
        }
        XmlSuite suite = new XmlSuite();
        testng.setXmlSuites(Collections.singletonList(suite));
        if (this.getConfiguration().getTestSources().isEmpty()) {
            this.addTestPackages(suite, this.getConfiguration());
        } else {
            this.addTestClasses(suite, this.getConfiguration());
            this.addTestSources(suite, this.getConfiguration());
        }
        testng.run();
    }

    private void addTestSources(XmlSuite suite, TestRunConfiguration configuration) {
        List<TestSource> testSources = configuration.getTestSources().stream().filter(source -> !"java".equals(source.getType()) || !TestClass.isKnownToClasspath((String)source.getName())).toList();
        for (TestSource source2 : testSources) {
            logger.info(String.format("Running test source %s", source2.getName()));
            XmlTest test = new XmlTest(suite);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("name", source2.getName());
            parameters.put("source", Optional.ofNullable(source2.getFilePath()).orElse(""));
            test.setParameters(parameters);
            XmlClass xmlClass = new XmlClass(TestNGCitrusTest.class);
            xmlClass.setIncludedMethods(Collections.singletonList(new XmlInclude("execute")));
            test.setClasses(Collections.singletonList(xmlClass));
        }
    }

    private void addTestPackages(XmlSuite suite, TestRunConfiguration configuration) {
        List<String> packagesToRun = configuration.getPackages();
        if (packagesToRun == null || packagesToRun.isEmpty()) {
            packagesToRun = Collections.singletonList("");
            logger.info("Running all tests in project");
        }
        for (String packageName : packagesToRun) {
            if (StringUtils.hasText((String)packageName)) {
                logger.info(String.format("Running tests in package %s", packageName));
            }
            XmlTest test = new XmlTest(suite);
            test.setClasses(new ArrayList());
            List classesToRun = configuration.getTestJar() != null ? new JarFileTestScanner(configuration.getTestJar(), configuration.getIncludes()).findTestsInPackage(packageName) : new ClassPathTestScanner(Test.class, configuration.getIncludes()).findTestsInPackage(packageName);
            classesToRun.stream().peek(testClass -> {
                Object[] objectArray = new Object[1];
                objectArray[0] = Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName());
                logger.info(String.format("Running test %s", objectArray));
            }).map(testClass -> {
                try {
                    Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                    return clazz;
                }
                catch (ClassNotFoundException | MalformedURLException e) {
                    logger.warn("Unable to read test class: " + testClass.getName());
                    return Void.class;
                }
            }).filter(clazz -> !clazz.equals(Void.class)).map(XmlClass::new).forEach(test.getClasses()::add);
            logger.info(String.format("Found %s test classes to execute", test.getClasses().size()));
        }
    }

    private void addTestClasses(XmlSuite suite, TestRunConfiguration configuration) {
        List<TestClass> testClasses = configuration.getTestSources().stream().filter(source -> "java".equals(source.getType())).map(TestSource::getName).filter(TestClass::isKnownToClasspath).map(TestClass::fromString).toList();
        for (TestClass testClass : testClasses) {
            Object[] objectArray = new Object[1];
            objectArray[0] = Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName());
            logger.info(String.format("Running test %s", objectArray));
            XmlTest test = new XmlTest(suite);
            test.setClasses(new ArrayList());
            try {
                Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                XmlClass xmlClass = new XmlClass(clazz);
                if (StringUtils.hasText((String)testClass.getMethod())) {
                    xmlClass.setIncludedMethods(Collections.singletonList(new XmlInclude(testClass.getMethod())));
                }
                test.getClasses().add(xmlClass);
            }
            catch (ClassNotFoundException | MalformedURLException e) {
                logger.warn("Unable to read test class: " + testClass.getName());
            }
        }
    }

    public TestNGEngine addTestListener(ITestNGListener listener) {
        this.listeners.add(listener);
        return this;
    }
}

