/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.testng;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestParameterAware;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.testng.CitrusParameters;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public final class TestNGParameterHelper {
    private TestNGParameterHelper() {
    }

    public static Object[] resolveParameter(Object target, ITestResult testResult, Method method, TestContext context, int invocationCount) {
        Object[] dataProviderParams = null;
        if (method.getAnnotation(Test.class) != null && StringUtils.hasText((String)method.getAnnotation(Test.class).dataProvider())) {
            Method[] dataProvider = new Method[1];
            ReflectionUtils.doWithMethods(method.getDeclaringClass(), current -> {
                if (StringUtils.hasText((String)current.getAnnotation(DataProvider.class).name()) && current.getAnnotation(DataProvider.class).name().equals(method.getAnnotation(Test.class).dataProvider())) {
                    dataProvider[0] = current;
                } else if (current.getName().equals(method.getAnnotation(Test.class).dataProvider())) {
                    dataProvider[0] = current;
                }
            }, toFilter -> toFilter.getAnnotation(DataProvider.class) != null);
            if (dataProvider[0] == null) {
                throw new CitrusRuntimeException("Unable to find data provider: " + method.getAnnotation(Test.class).dataProvider());
            }
            Object[][] parameters = (Object[][])ReflectionUtils.invokeMethod((Method)dataProvider[0], (Object)target, (Object[])TestNGParameterHelper.resolveParameter(target, testResult, dataProvider[0], context, -1));
            if (parameters != null) {
                dataProviderParams = parameters[invocationCount % parameters.length];
            }
        }
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations = method.getParameterAnnotations()[i];
            Class<?> parameterType = parameterTypes[i];
            for (Annotation annotation : parameterAnnotations) {
                if (!(annotation instanceof CitrusResource)) continue;
                values[i] = TestNGParameterHelper.resolveAnnotatedResource(testResult, parameterType, context);
            }
            if (parameterType.equals(ITestResult.class)) {
                values[i] = testResult;
                continue;
            }
            if (parameterType.equals(ITestContext.class)) {
                values[i] = testResult.getTestContext();
                continue;
            }
            if (values[i] != null || dataProviderParams == null || i >= dataProviderParams.length) continue;
            values[i] = dataProviderParams[i];
        }
        return values;
    }

    private static Object resolveAnnotatedResource(ITestResult testResult, Class<?> parameterType, TestContext context) {
        Object storedBuilder = testResult.getAttribute("builder");
        if (TestCaseRunner.class.isAssignableFrom(parameterType)) {
            return storedBuilder;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof TestActionRunner) {
            return storedBuilder;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof GherkinTestActionRunner) {
            return storedBuilder;
        }
        if (TestContext.class.isAssignableFrom(parameterType)) {
            return context;
        }
        throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + parameterType);
    }

    public static void injectTestParameters(Method method, TestCase testCase, Object[] parameterValues) {
        if (testCase instanceof TestParameterAware) {
            ((TestParameterAware)testCase).setParameters(TestNGParameterHelper.getParameterNames(method), parameterValues);
        }
    }

    private static String[] getParameterNames(Method method) {
        String[] parameterNames;
        CitrusParameters citrusParameters = method.getAnnotation(CitrusParameters.class);
        Parameters testNgParameters = method.getAnnotation(Parameters.class);
        if (citrusParameters != null) {
            parameterNames = citrusParameters.value();
        } else if (testNgParameters != null) {
            parameterNames = testNgParameters.value();
        } else {
            ArrayList<String> methodParameterNames = new ArrayList<String>();
            for (Parameter parameter : method.getParameters()) {
                methodParameterNames.add(parameter.getName());
            }
            parameterNames = methodParameterNames.toArray(new String[0]);
        }
        return parameterNames;
    }
}

