/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.xml.namespace.CitrusNamespacePrefixMapper;
import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlTestMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(XmlTestMarshaller.class);
    private volatile JAXBContext jaxbContext;
    private final Schema schema;
    private String contextPath;
    private NamespacePrefixMapper namespacePrefixMapper = new CitrusNamespacePrefixMapper();

    public XmlTestMarshaller() {
        this.schema = this.loadSchema(Resources.fromClasspath((String)"org/citrusframework/schema/citrus-testcase.xsd"));
    }

    public void marshal(Object graph, Result result) {
        try {
            this.createMarshaller().marshal(graph, result);
        }
        catch (JAXBException e) {
            throw new CitrusRuntimeException("Failed to marshal object graph", (Throwable)e);
        }
    }

    public Object unmarshal(Source source) {
        try {
            return this.createUnmarshaller().unmarshal(source);
        }
        catch (JAXBException e) {
            throw new CitrusRuntimeException("Failed to unmarshal source", (Throwable)e);
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.getOrCreateContext().createMarshaller();
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.fragment", (Object)true);
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)this.namespacePrefixMapper);
        marshaller.setProperty("jakarta.xml.bind.namespacePrefixMapper", (Object)this.namespacePrefixMapper);
        return marshaller;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.getOrCreateContext().createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getOrCreateContext() throws JAXBException {
        if (this.jaxbContext == null) {
            XmlTestMarshaller xmlTestMarshaller = this;
            synchronized (xmlTestMarshaller) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Creating JAXBContext with context path %s", this.contextPath));
                }
                this.jaxbContext = JAXBContext.newInstance((String)this.contextPath);
            }
        }
        return this.jaxbContext;
    }

    private Schema loadSchema(Resource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Using marshaller validation schema '%s'", resource.getLocation()));
        }
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (resource == null || !resource.exists()) {
                throw new ValidationException("Resource does not exist: " + resource);
            }
            InputSource inputSource = new InputSource(resource.getInputStream());
            inputSource.setSystemId(resource.getURI().toString());
            SAXSource schemaSource = new SAXSource(xmlReader, inputSource);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(schemaSource);
        }
        catch (SAXException e) {
            throw new CitrusRuntimeException("Failed to load schema for marshaller", (Throwable)e);
        }
    }

    public void setContextPaths(List<String> contextPaths) {
        this.contextPath = String.join((CharSequence)":", contextPaths.toArray(new String[0]));
    }

    public NamespacePrefixMapper getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public void setNamespacePrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }
}

