/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ssh.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PublicKey;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SinglePublicKeyAuthenticator
implements PublickeyAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(SinglePublicKeyAuthenticator.class);
    private final PublicKey allowedKey;
    private final String user;

    public SinglePublicKeyAuthenticator(String username, String publicKeyPath) {
        this.user = username;
        try (InputStream is = FileUtils.getFileResource((String)publicKeyPath).getInputStream();){
            if (is == null) {
                throw new CitrusRuntimeException(String.format("Failed to read public key - no public key found at %s", publicKeyPath));
            }
            this.allowedKey = this.readKey(is);
            if (this.allowedKey == null) {
                throw new CitrusRuntimeException("No public key found at " + publicKeyPath + ", although the file/resource exists. It is probably not in a PEM form or contains more than only a public key.");
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to read public key file at %s", publicKeyPath), (Throwable)e);
        }
    }

    public boolean authenticate(String pUser, PublicKey pKey, ServerSession pSession) {
        return this.user != null && this.user.equals(pUser) && this.allowedKey.equals(pKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PublicKey readKey(InputStream is) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(is);
             PEMParser pemParser = new PEMParser((Reader)inputStreamReader);){
            Object o = pemParser.readObject();
            if (o instanceof PEMKeyPair) {
                PEMKeyPair keyPair = (PEMKeyPair)o;
                if (keyPair.getPublicKeyInfo() == null) return null;
                if (keyPair.getPublicKeyInfo().getEncoded().length <= 0) return null;
                PublicKey publicKey = BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)keyPair.getPublicKeyInfo());
                return publicKey;
            }
            if (!(o instanceof SubjectPublicKeyInfo)) return null;
            SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)o;
            PublicKey publicKey = BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
            return publicKey;
        }
        catch (IOException e) {
            logger.warn("Failed to get key from PEM file", (Throwable)e);
        }
        return null;
    }
}

