/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ssh.message;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageConverter;
import org.citrusframework.ssh.client.SshEndpointConfiguration;
import org.citrusframework.ssh.model.SshMessage;
import org.citrusframework.xml.StringResult;

public class SshMessageConverter
implements MessageConverter<SshMessage, SshMessage, SshEndpointConfiguration> {
    public SshMessage convertOutbound(Message internalMessage, SshEndpointConfiguration endpointConfiguration, TestContext context) {
        Object payload = internalMessage.getPayload();
        SshMessage sshMessage = null;
        if (payload != null) {
            sshMessage = payload instanceof SshMessage ? (SshMessage)payload : (SshMessage)endpointConfiguration.getSshMarshaller().unmarshal((Source)internalMessage.getPayload(Source.class));
        }
        if (sshMessage == null) {
            throw new CitrusRuntimeException("Unable to create proper ssh message from payload: " + payload);
        }
        return sshMessage;
    }

    public void convertOutbound(SshMessage externalMessage, Message internalMessage, SshEndpointConfiguration endpointConfiguration, TestContext context) {
    }

    public Message convertInbound(SshMessage externalMessage, SshEndpointConfiguration endpointConfiguration, TestContext context) {
        StringResult payload = new StringResult();
        endpointConfiguration.getSshMarshaller().marshal(externalMessage, (Result)payload);
        return new DefaultMessage((Object)payload.toString());
    }
}

