/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ssh.config.annotation;

import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.ssh.client.SshClient;
import org.citrusframework.ssh.client.SshClientBuilder;
import org.citrusframework.ssh.config.annotation.SshClientConfig;
import org.citrusframework.ssh.message.SshMessageConverter;
import org.citrusframework.util.StringUtils;

public class SshClientConfigParser
implements AnnotationConfigParser<SshClientConfig, SshClient> {
    public SshClient parse(SshClientConfig annotation, ReferenceResolver referenceResolver) {
        SshClientBuilder builder = new SshClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        if (StringUtils.hasText((String)annotation.privateKeyPath())) {
            builder.privateKeyPath(annotation.privateKeyPath());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPassword())) {
            builder.privateKeyPassword(annotation.privateKeyPassword());
        }
        builder.strictHostChecking(annotation.strictHostChecking());
        if (StringUtils.hasText((String)annotation.knownHosts())) {
            builder.knownHosts(annotation.knownHosts());
        }
        builder.commandTimeout(annotation.commandTimeout());
        builder.connectionTimeout(annotation.connectionTimeout());
        if (StringUtils.hasText((String)annotation.user())) {
            builder.user(annotation.user());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((SshMessageConverter)referenceResolver.resolve(annotation.messageConverter(), SshMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (SshClient)builder.initialize().build();
    }
}

