/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ssh.client;

import java.util.Map;
import java.util.StringTokenizer;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.ssh.client.SshClient;

public class SshEndpointComponent
extends AbstractEndpointComponent {
    public SshEndpointComponent() {
        super("ssh");
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        SshClient client = new SshClient();
        if (resourcePath.contains(":")) {
            StringTokenizer tok = new StringTokenizer(resourcePath, ":");
            client.getEndpointConfiguration().setHost(tok.nextToken());
            if (tok.hasMoreTokens()) {
                client.getEndpointConfiguration().setPort(Integer.parseInt(tok.nextToken()));
            }
        } else {
            client.getEndpointConfiguration().setHost(resourcePath);
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)client.getEndpointConfiguration(), parameters, context);
        return client;
    }
}

