/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ssh.client;

import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.ssh.client.SshClient;
import org.citrusframework.ssh.message.SshMessageConverter;

public class SshClientBuilder
extends AbstractEndpointBuilder<SshClient> {
    private SshClient endpoint = new SshClient();

    protected SshClient getEndpoint() {
        return this.endpoint;
    }

    public SshClientBuilder host(String host) {
        this.endpoint.getEndpointConfiguration().setHost(host);
        return this;
    }

    public SshClientBuilder port(int port) {
        this.endpoint.getEndpointConfiguration().setPort(port);
        return this;
    }

    public SshClientBuilder user(String user) {
        this.endpoint.getEndpointConfiguration().setUser(user);
        return this;
    }

    public SshClientBuilder password(String password) {
        this.endpoint.getEndpointConfiguration().setPassword(password);
        return this;
    }

    public SshClientBuilder privateKeyPath(String privateKeyPath) {
        this.endpoint.getEndpointConfiguration().setPrivateKeyPath(privateKeyPath);
        return this;
    }

    public SshClientBuilder privateKeyPassword(String privateKeyPassword) {
        this.endpoint.getEndpointConfiguration().setPrivateKeyPassword(privateKeyPassword);
        return this;
    }

    public SshClientBuilder strictHostChecking(boolean strictHostChecking) {
        this.endpoint.getEndpointConfiguration().setStrictHostChecking(strictHostChecking);
        return this;
    }

    public SshClientBuilder knownHosts(String knownHosts) {
        this.endpoint.getEndpointConfiguration().setKnownHosts(knownHosts);
        return this;
    }

    public SshClientBuilder commandTimeout(long commandTimeout) {
        this.endpoint.getEndpointConfiguration().setCommandTimeout(commandTimeout);
        return this;
    }

    public SshClientBuilder connectionTimeout(int connectionTimeout) {
        this.endpoint.getEndpointConfiguration().setConnectionTimeout(connectionTimeout);
        return this;
    }

    public SshClientBuilder messageConverter(SshMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public SshClientBuilder correlator(MessageCorrelator correlator) {
        this.endpoint.getEndpointConfiguration().setCorrelator(correlator);
        return this;
    }

    public SshClientBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    public SshClientBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

