/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import org.citrusframework.actions.ExecutePLSQLAction;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractDatabaseConnectingTestActionFactoryBean;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ExecutePLSQLActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String ignoreErrors;
        Element sqlResourceElement;
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ExecutePLSQLActionFactoryBean.class);
        String dataSource = element.getAttribute("datasource");
        beanDefinition.addPropertyValue("name", (Object)(element.getLocalName() + ":" + dataSource));
        beanDefinition.addPropertyReference("dataSource", dataSource);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("transaction-manager"), (String)"transactionManager");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("transaction-timeout"), (String)"transactionTimeout");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("transaction-isolation-level"), (String)"transactionIsolationLevel");
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)beanDefinition);
        Element scriptElement = DomUtils.getChildElementByTagName((Element)element, (String)"script");
        if (scriptElement != null) {
            beanDefinition.addPropertyValue("script", (Object)DomUtils.getTextValue((Element)scriptElement).trim());
        }
        if ((sqlResourceElement = DomUtils.getChildElementByTagName((Element)element, (String)"resource")) != null) {
            beanDefinition.addPropertyValue("sqlResourcePath", (Object)sqlResourceElement.getAttribute("file"));
        }
        if ((ignoreErrors = element.getAttribute("ignore-errors")) != null && ignoreErrors.equals("true")) {
            beanDefinition.addPropertyValue("ignoreErrors", (Object)true);
        }
        return beanDefinition.getBeanDefinition();
    }

    public static class ExecutePLSQLActionFactoryBean
    extends AbstractDatabaseConnectingTestActionFactoryBean<ExecutePLSQLAction, ExecutePLSQLAction.Builder> {
        private final ExecutePLSQLAction.Builder builder = new ExecutePLSQLAction.Builder();

        public ExecutePLSQLAction getObject() throws Exception {
            return this.builder.build();
        }

        public void setIgnoreErrors(boolean ignoreErrors) {
            this.builder.ignoreErrors(ignoreErrors);
        }

        public void setScript(String script) {
            this.builder.sqlScript(script);
        }

        public Class<?> getObjectType() {
            return ExecutePLSQLAction.class;
        }

        public ExecutePLSQLAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

