/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActor;
import org.citrusframework.TestActorAware;
import org.citrusframework.common.Described;
import org.citrusframework.common.Named;
import org.citrusframework.context.TestContext;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.SqlUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractDatabaseConnectingTestAction
extends JdbcDaoSupport
implements TestAction,
Named,
Described,
TestActorAware {
    private String description;
    private String name;
    private TestActor actor;
    protected final String sqlResourcePath;
    protected final List<String> statements;
    private final PlatformTransactionManager transactionManager;
    private final String transactionTimeout;
    private final String transactionIsolationLevel;

    protected AbstractDatabaseConnectingTestAction(String name, Builder<?, ?> builder) {
        this.name = Optional.ofNullable(builder.getName()).orElse(name);
        this.description = builder.getDescription();
        this.actor = builder.getActor();
        Optional.ofNullable(builder.jdbcTemplate).ifPresent(x$0 -> super.setJdbcTemplate(x$0));
        Optional.ofNullable(builder.dataSource).ifPresent(x$0 -> super.setDataSource(x$0));
        this.sqlResourcePath = builder.sqlResourcePath;
        this.transactionIsolationLevel = builder.transactionIsolationLevel;
        this.transactionManager = builder.transactionManager;
        this.transactionTimeout = builder.transactionTimeout;
        this.statements = builder.statements;
    }

    public void execute(TestContext context) {
        if (!this.isDisabled(context)) {
            this.doExecute(context);
        }
    }

    public abstract void doExecute(TestContext var1);

    public boolean isDisabled(TestContext context) {
        if (this.actor != null) {
            return this.actor.isDisabled();
        }
        return false;
    }

    protected List<String> createStatementsFromFileResource(TestContext context) {
        return SqlUtils.createStatementsFromFileResource(Resources.fromClasspath((String)context.replaceDynamicContentInString(this.sqlResourcePath)));
    }

    protected List<String> createStatementsFromFileResource(TestContext context, SqlUtils.LastScriptLineDecorator lineDecorator) {
        return SqlUtils.createStatementsFromFileResource(Resources.fromClasspath((String)context.replaceDynamicContentInString(this.sqlResourcePath)), lineDecorator);
    }

    public String getDescription() {
        return this.description;
    }

    public AbstractDatabaseConnectingTestAction setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSqlResourcePath() {
        return this.sqlResourcePath;
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public String getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public String getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public TestActor getActor() {
        return this.actor;
    }

    public AbstractDatabaseConnectingTestAction setActor(TestActor actor) {
        this.actor = actor;
        return this;
    }

    public static abstract class Builder<T extends AbstractDatabaseConnectingTestAction, S extends Builder<T, S>>
    extends AbstractTestActionBuilder<T, S> {
        protected JdbcTemplate jdbcTemplate;
        protected DataSource dataSource;
        protected String sqlResourcePath;
        protected final List<String> statements = new ArrayList<String>();
        protected PlatformTransactionManager transactionManager;
        protected String transactionTimeout = String.valueOf(-1);
        protected String transactionIsolationLevel = "ISOLATION_DEFAULT";

        public S jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return (S)((Object)((Builder)this.self));
        }

        public S transactionManager(PlatformTransactionManager transactionManager) {
            this.transactionManager = transactionManager;
            return (S)((Object)((Builder)this.self));
        }

        public S transactionTimeout(int transactionTimeout) {
            this.transactionTimeout = String.valueOf(transactionTimeout);
            return (S)((Object)((Builder)this.self));
        }

        public S transactionTimeout(String transactionTimeout) {
            this.transactionTimeout = transactionTimeout;
            return (S)((Object)((Builder)this.self));
        }

        public S transactionIsolationLevel(String isolationLevel) {
            this.transactionIsolationLevel = isolationLevel;
            return (S)((Object)((Builder)this.self));
        }

        public S dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return (S)((Object)((Builder)this.self));
        }

        public S statements(List<String> statements) {
            this.statements.addAll(statements);
            return (S)((Object)((Builder)this.self));
        }

        public S statement(String sql) {
            this.statements.add(sql);
            return (S)((Object)((Builder)this.self));
        }

        public S sqlResource(Resource sqlResource) {
            this.statements(SqlUtils.createStatementsFromFileResource(sqlResource));
            return (S)((Object)((Builder)this.self));
        }

        public S sqlResource(String filePath) {
            this.sqlResourcePath = filePath;
            return (S)((Object)((Builder)this.self));
        }
    }
}

