/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.sql.yaml;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.AbstractDatabaseConnectingTestAction;
import org.citrusframework.actions.ExecuteSQLAction;
import org.citrusframework.actions.ExecuteSQLQueryAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.StringUtils;
import org.springframework.transaction.PlatformTransactionManager;

public class Sql
implements TestActionBuilder<AbstractDatabaseConnectingTestAction>,
ReferenceResolverAware {
    private AbstractDatabaseConnectingTestAction.Builder<?, ?> builder = new ExecuteSQLAction.Builder();
    private String dataSource;
    private String transactionManager;
    private ReferenceResolver referenceResolver;
    protected List<Validate> validate;
    protected List<Extract> extract;

    public void setDescription(String value) {
        this.builder.description(value);
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
        this.builder.name(String.format("sql:%s", dataSource));
    }

    public void setStatements(List<Statement> statements) {
        for (Statement statement : statements) {
            if (statement.statement != null) {
                this.builder.statement(statement.statement);
            }
            if (statement.file == null) continue;
            this.builder.sqlResource(statement.file);
        }
    }

    public void setTransaction(Transaction transaction) {
        if (transaction.manager != null) {
            this.transactionManager = transaction.manager;
        }
        if (transaction.isolationLevel != null) {
            this.builder.transactionIsolationLevel(transaction.isolationLevel);
        }
        if (transaction.timeout != null) {
            this.builder.transactionTimeout(transaction.timeout);
        }
    }

    public void setIgnoreErrors(boolean value) {
        if (this.builder instanceof ExecuteSQLAction.Builder) {
            ((ExecuteSQLAction.Builder)this.builder).ignoreErrors(value);
        }
    }

    public List<Validate> getValidates() {
        if (this.validate == null) {
            this.validate = new ArrayList<Validate>();
        }
        return this.validate;
    }

    public void setValidate(List<Validate> validate) {
        this.validate = validate;
    }

    public List<Extract> getExtracts() {
        if (this.extract == null) {
            this.extract = new ArrayList<Extract>();
        }
        return this.extract;
    }

    public void setExtract(List<Extract> extract) {
        this.extract = extract;
    }

    public AbstractDatabaseConnectingTestAction build() {
        if (this.referenceResolver != null) {
            this.builder.dataSource((DataSource)this.referenceResolver.resolve(this.dataSource, DataSource.class));
            if (this.transactionManager != null) {
                this.builder.transactionManager((PlatformTransactionManager)this.referenceResolver.resolve(this.transactionManager, PlatformTransactionManager.class));
            }
        }
        for (Validate validate : this.getValidates()) {
            Validate.Script script;
            if (validate.column != null) {
                if (validate.value != null) {
                    this.asSqlQueryBuilder().validate(validate.column, validate.value);
                }
                if (validate.getValues() != null) {
                    this.asSqlQueryBuilder().validate(validate.column, (String[])validate.getValues().toArray(String[]::new));
                }
            }
            if ((script = validate.script) == null) continue;
            String type = script.getType();
            String filePath = script.getFile();
            if (StringUtils.hasText((String)filePath)) {
                if (script.getCharset() != null) {
                    this.asSqlQueryBuilder().validateScriptResource(filePath, type, Charset.forName(script.getCharset()));
                    continue;
                }
                this.asSqlQueryBuilder().validateScriptResource(filePath, type, StandardCharsets.UTF_8);
                continue;
            }
            if (script.getValue() == null) continue;
            this.asSqlQueryBuilder().validateScript(script.getValue().trim(), type);
        }
        for (Extract extract : this.getExtracts()) {
            this.asSqlQueryBuilder().extract(extract.column, extract.variable);
        }
        return (AbstractDatabaseConnectingTestAction)this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private ExecuteSQLQueryAction.Builder asSqlQueryBuilder() {
        if (this.builder instanceof ExecuteSQLQueryAction.Builder) {
            return (ExecuteSQLQueryAction.Builder)this.builder;
        }
        ExecuteSQLQueryAction.Builder sqlQueryBuilder = new ExecuteSQLQueryAction.Builder();
        AbstractDatabaseConnectingTestAction base = (AbstractDatabaseConnectingTestAction)this.builder.build();
        sqlQueryBuilder.description(base.getDescription());
        sqlQueryBuilder.dataSource(base.getDataSource());
        sqlQueryBuilder.jdbcTemplate(base.getJdbcTemplate());
        sqlQueryBuilder.sqlResource(base.getSqlResourcePath());
        sqlQueryBuilder.statements(base.getStatements());
        sqlQueryBuilder.transactionManager(base.getTransactionManager());
        sqlQueryBuilder.transactionTimeout(base.getTransactionTimeout());
        sqlQueryBuilder.transactionIsolationLevel(base.getTransactionIsolationLevel());
        sqlQueryBuilder.actor(base.getActor());
        this.builder = sqlQueryBuilder;
        return sqlQueryBuilder;
    }

    public static class Statement {
        private String statement;
        private String file;

        public String getFile() {
            return this.file;
        }

        public void setFile(String value) {
            this.file = value;
        }

        public String getStatement() {
            return this.statement;
        }

        public void setStatement(String statement) {
            this.statement = statement;
        }
    }

    public static class Transaction {
        protected String manager;
        protected String timeout;
        protected String isolationLevel;

        public String getManager() {
            return this.manager;
        }

        public void setManager(String manager) {
            this.manager = manager;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String getIsolationLevel() {
            return this.isolationLevel;
        }

        public void setIsolationLevel(String isolationLevel) {
            this.isolationLevel = isolationLevel;
        }
    }

    public static class Validate {
        protected List<String> values;
        protected String column;
        protected String value;
        protected Script script;

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> value) {
            this.values = value;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String value) {
            this.column = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Script getScript() {
            return this.script;
        }

        public void setScript(Script script) {
            this.script = script;
        }

        public static class Script {
            protected String value;
            protected String type;
            protected String file;
            protected String charset;

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String value) {
                this.type = value;
            }

            public String getFile() {
                return this.file;
            }

            public void setFile(String value) {
                this.file = value;
            }

            public void setCharset(String charset) {
                this.charset = charset;
            }

            public String getCharset() {
                return this.charset;
            }
        }
    }

    public static class Extract {
        protected String column;
        protected String variable;

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String value) {
            this.column = value;
        }

        public String getVariable() {
            return this.variable;
        }

        public void setVariable(String value) {
            this.variable = value;
        }
    }
}

