/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.citrusframework.xml.Marshaller;
import org.citrusframework.xml.Unmarshaller;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.XmlMappingException;

public class SpringMarshallerAdapter
implements org.springframework.oxm.Marshaller,
org.springframework.oxm.Unmarshaller {
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public SpringMarshallerAdapter(Marshaller marshaller) {
        this.marshaller = marshaller;
        if (!(marshaller instanceof Unmarshaller)) {
            throw new IllegalArgumentException("Failed to initialize Spring Oxm marshaller - missing proper unmarshaller delegate");
        }
        this.unmarshaller = (Unmarshaller)marshaller;
    }

    public SpringMarshallerAdapter(Marshaller marshaller, Unmarshaller unmarshaller) {
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public Object unmarshal(Source source) throws IOException, XmlMappingException {
        try {
            return this.unmarshaller.unmarshal(source);
        }
        catch (Exception e) {
            throw new UnmarshallingFailureException("Failed to unmarshal source", e.getCause());
        }
    }

    public void marshal(Object graph, Result result) throws IOException, XmlMappingException {
        try {
            this.marshaller.marshal(graph, result);
        }
        catch (Exception e) {
            throw new MarshallingFailureException("Failed to marshal object graph", e.getCause());
        }
    }
}

