/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;

public class SpringResourceWrapper
implements org.springframework.core.io.Resource {
    private final Resource delegate;

    public SpringResourceWrapper(Resource delegate) {
        this.delegate = delegate;
    }

    public static SpringResourceWrapper from(Resource resource) {
        return new SpringResourceWrapper(resource);
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public URL getURL() throws IOException {
        return this.delegate.getURL();
    }

    public URI getURI() throws IOException {
        return this.delegate.getURI();
    }

    public File getFile() throws IOException {
        return this.delegate.getFile();
    }

    public long contentLength() throws IOException {
        try {
            return this.delegate.getFile().length();
        }
        catch (Exception e) {
            return Files.size(new File(this.delegate.getLocation()).toPath());
        }
    }

    public long lastModified() throws IOException {
        try {
            return this.delegate.getFile().lastModified();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getFilename() {
        return FileUtils.getFileName((String)this.delegate.getLocation());
    }

    public String getDescription() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public static class ResourceConverter
    implements Converter<Resource, org.springframework.core.io.Resource>,
    ConditionalConverter {
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return Resource.class.isAssignableFrom(sourceType.getObjectType()) && org.springframework.core.io.Resource.class.isAssignableFrom(targetType.getObjectType());
        }

        public org.springframework.core.io.Resource convert(Resource source) {
            return new SpringResourceWrapper(source);
        }
    }
}

