/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildListener;
import org.citrusframework.actions.AntRunAction;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractTestActionFactoryBean;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AntRunActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(AntRunActionFactoryBean.class);
        DescriptionElementParser.doParse(element, beanDefinition);
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("build-file"), "buildFilePath");
        Element executeElement = DomUtils.getChildElementByTagName((Element)element, (String)"execute");
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, executeElement.getAttribute("target"), "target");
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, executeElement.getAttribute("targets"), "targets");
        Properties properties = new Properties();
        Element propertiesElement = DomUtils.getChildElementByTagName((Element)element, (String)"properties");
        if (propertiesElement != null) {
            BeanDefinitionParserUtils.setPropertyValue(beanDefinition, propertiesElement.getAttribute("file"), "propertyFilePath");
            List propertyElements = DomUtils.getChildElementsByTagName((Element)propertiesElement, (String)"property");
            if (!propertyElements.isEmpty()) {
                for (Object o : propertyElements) {
                    Element propertyElement = (Element)o;
                    properties.put(propertyElement.getAttribute("name"), propertyElement.getAttribute("value"));
                }
                beanDefinition.addPropertyValue("properties", (Object)properties);
            }
        }
        BeanDefinitionParserUtils.setPropertyReference(beanDefinition, element.getAttribute("build-listener"), "buildListener");
        return beanDefinition.getBeanDefinition();
    }

    public static class AntRunActionFactoryBean
    extends AbstractTestActionFactoryBean<AntRunAction, AntRunAction.Builder> {
        private final AntRunAction.Builder builder = new AntRunAction.Builder();

        public void setBuildFilePath(String buildFilePath) {
            this.builder.buildFilePath(buildFilePath);
        }

        public void setTarget(String target) {
            this.builder.target(target);
        }

        public void setTargets(String targets) {
            this.builder.targets(new String[]{targets});
        }

        public void setProperties(Properties properties) {
            this.builder.properties(properties);
        }

        public void setPropertyFilePath(String propertyFilePath) {
            this.builder.propertyFile(propertyFilePath);
        }

        public void setBuildListener(BuildListener buildListener) {
            this.builder.listener(buildListener);
        }

        public AntRunAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return AntRunAction.class;
        }

        @Override
        public AntRunAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

