/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.common;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.CitrusContext;
import org.citrusframework.CitrusSpringContext;
import org.citrusframework.DefaultTestCaseRunner;
import org.citrusframework.TestAction;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.common.BeanDefinitionParserConfiguration;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.SpringXmlTestLoaderConfiguration;
import org.citrusframework.common.SpringXmlTestLoaderConfigurer;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.config.CitrusNamespaceParserRegistry;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringXmlTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private String source;

    protected void doLoad() {
        ApplicationContext ctx = this.loadApplicationContext();
        try {
            this.testCase = (TestCase)ctx.getBean(this.testName, TestCase.class);
            TestCaseRunner testCaseRunner = this.runner;
            if (testCaseRunner instanceof DefaultTestCaseRunner) {
                DefaultTestCaseRunner defaultTestCaseRunner = (DefaultTestCaseRunner)testCaseRunner;
                defaultTestCaseRunner.setTestCase(this.testCase);
            }
            this.configurer.forEach(handler -> handler.accept(this.testCase));
            this.citrus.run((TestAction)this.testCase, this.context);
            this.handler.forEach(handler -> handler.accept(this.testCase));
        }
        catch (NoSuchBeanDefinitionException e) {
            throw this.context.handleError(this.testName, this.packageName, "Failed to load Spring XML test with name '" + this.testName + "'", (Exception)((Object)e));
        }
    }

    private ApplicationContext loadApplicationContext() {
        try {
            ApplicationContext parentApplicationContext = this.getParentApplicationContext();
            this.configureCustomParsers(parentApplicationContext);
            return new ClassPathXmlApplicationContext(new String[]{this.getSource(), "org/citrusframework/spring/annotation-config-ctx.xml"}, true, parentApplicationContext);
        }
        catch (Exception e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load test case", e);
        }
    }

    private void configureCustomParsers(ApplicationContext parentApplicationContext) {
        List<SpringXmlTestLoaderConfiguration> beanDefinitionParserConfigurationList = this.retrieveSpringXmlTestLoaderConfigurations(parentApplicationContext);
        for (SpringXmlTestLoaderConfiguration loaderConfiguration : beanDefinitionParserConfigurationList) {
            for (BeanDefinitionParserConfiguration beanDefinitionParserConfiguration : loaderConfiguration.parserConfigurations()) {
                Class<? extends BeanDefinitionParser> parserClass = beanDefinitionParserConfiguration.parser();
                try {
                    if (parserClass == null) continue;
                    BeanDefinitionParser parserOverride = parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    CitrusNamespaceParserRegistry.registerParser(beanDefinitionParserConfiguration.name(), parserOverride);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CitrusRuntimeException(String.format("Could not install custom BeanDefinitionParser '%s'", parserClass), (Throwable)e);
                }
            }
        }
    }

    private List<SpringXmlTestLoaderConfiguration> retrieveSpringXmlTestLoaderConfigurations(ApplicationContext applicationContext) {
        ArrayList<SpringXmlTestLoaderConfiguration> beanDefinitionParserConfigurationList = new ArrayList<SpringXmlTestLoaderConfiguration>();
        this.addOptionalTestClassLevelAnnotation(this.testClass, beanDefinitionParserConfigurationList);
        this.addOptionalConfigurerClassLevelAnnotations(applicationContext, beanDefinitionParserConfigurationList);
        return beanDefinitionParserConfigurationList;
    }

    private void addOptionalConfigurerClassLevelAnnotations(ApplicationContext applicationContext, List<SpringXmlTestLoaderConfiguration> beanDefinitionParserConfigurationList) {
        if (applicationContext != null) {
            applicationContext.getBeansOfType(SpringXmlTestLoaderConfigurer.class).values().forEach(configurer -> this.addOptionalTestClassLevelAnnotation(configurer.getClass(), beanDefinitionParserConfigurationList));
        }
    }

    private void addOptionalTestClassLevelAnnotation(Class<?> testClass, List<SpringXmlTestLoaderConfiguration> beanDefinitionParserConfigurationList) {
        SpringXmlTestLoaderConfiguration loaderConfiguration = testClass.getAnnotation(SpringXmlTestLoaderConfiguration.class);
        if (loaderConfiguration != null) {
            beanDefinitionParserConfigurationList.add(loaderConfiguration);
        }
    }

    private ApplicationContext getParentApplicationContext() {
        CitrusContext citrusContext = this.citrusContext;
        if (citrusContext instanceof CitrusSpringContext) {
            CitrusSpringContext citrusSpringContext = (CitrusSpringContext)citrusContext;
            return citrusSpringContext.getApplicationContext();
        }
        return null;
    }

    public String getSource() {
        if (StringUtils.hasText((String)this.source)) {
            return this.source;
        }
        String path = this.packageName.replace('.', '/');
        Object fileName = this.testName.endsWith(".xml") ? this.testName : this.testName + ".xml";
        return path + "/" + (String)fileName;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SpringXmlTestLoader source(String source) {
        this.setSource(source);
        return this;
    }
}

