/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.Map;
import org.citrusframework.actions.ReceiveTimeoutAction;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractTestActionFactoryBean;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.citrusframework.config.xml.MessageSelectorParser;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.util.StringUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ReceiveTimeoutActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ReceiveTimeoutActionFactoryBean.class);
        String endpointUri = element.getAttribute("endpoint");
        if (!StringUtils.hasText((String)endpointUri)) {
            throw new BeanCreationException("Missing proper message endpoint reference for expect timeout action - 'endpoint' attribute is required and should not be empty");
        }
        if (endpointUri.contains(":")) {
            beanDefinition.addPropertyValue("endpointUri", (Object)endpointUri);
        } else {
            beanDefinition.addPropertyReference("endpoint", endpointUri);
        }
        beanDefinition.addPropertyValue("name", (Object)(element.getLocalName() + ":" + endpointUri));
        DescriptionElementParser.doParse(element, beanDefinition);
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("wait"), "timeout");
        Element messageSelectorElement = DomUtils.getChildElementByTagName((Element)element, (String)"select");
        if (messageSelectorElement != null) {
            beanDefinition.addPropertyValue("messageSelector", (Object)DomUtils.getTextValue((Element)messageSelectorElement));
        }
        MessageSelectorParser.doParse(element, beanDefinition);
        return beanDefinition.getBeanDefinition();
    }

    public static class ReceiveTimeoutActionFactoryBean
    extends AbstractTestActionFactoryBean<ReceiveTimeoutAction, ReceiveTimeoutAction.Builder> {
        private final ReceiveTimeoutAction.Builder builder = new ReceiveTimeoutAction.Builder();

        public void setTimeout(long timeout) {
            this.builder.timeout(timeout);
        }

        public void setMessageSelector(String messageSelector) {
            this.builder.selector(messageSelector);
        }

        public void setMessageSelectorMap(Map<String, Object> messageSelector) {
            this.builder.selector(messageSelector);
        }

        public void setEndpoint(Endpoint endpoint) {
            this.builder.endpoint(endpoint);
        }

        public void setEndpointUri(String endpointUri) {
            this.builder.endpoint(endpointUri);
        }

        public ReceiveTimeoutAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return ReceiveTimeoutAction.class;
        }

        @Override
        public ReceiveTimeoutAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

