/*
 * Copyright the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.citrusframework.config.xml;

import org.citrusframework.container.Sequence;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/**
 * Bean definition parser for sequential container in test case.
 *
 * @author Christoph Deppisch
 */
public class SequenceParser implements BeanDefinitionParser {

    @Override
	public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SequenceFactoryBean.class);

        DescriptionElementParser.doParse(element, builder);
        ActionContainerParser.doParse(element, parserContext, builder);

        return builder.getBeanDefinition();
    }

    /**
     * Test action factory bean.
     */
    public static class SequenceFactoryBean extends AbstractTestContainerFactoryBean<Sequence, Sequence.Builder> {

        private final Sequence.Builder builder = new Sequence.Builder();

        @Override
        public Sequence getObject() throws Exception {
            return getObject(builder.build());
        }

        @Override
        public Class<?> getObjectType() {
            return Sequence.class;
        }

        /**
         * Obtains the builder.
         * @return the builder implementation.
         */
        @Override
        public Sequence.Builder getBuilder() {
            return builder;
        }
    }
}
