/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SchemaParser
implements BeanDefinitionParser {
    private static Logger log = LoggerFactory.getLogger(SchemaParser.class);
    private static final String RESOURCE_PATH = "META-INF/citrus/schema/parser";
    private static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/schema/parser");
    private static final Map<String, BeanDefinitionParser> SCHEMA_PARSER = new HashMap<String, BeanDefinitionParser>();

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String location = element.getAttribute("location");
        return this.lookupSchemaParser(location).parse(element, parserContext);
    }

    private BeanDefinitionParser lookupSchemaParser(String location) {
        String fileExtension = FileUtils.getFileExtension((String)location);
        if (SCHEMA_PARSER.containsKey(fileExtension)) {
            return SCHEMA_PARSER.get(fileExtension);
        }
        BeanDefinitionParser parser = (BeanDefinitionParser)TYPE_RESOLVER.resolve(fileExtension, new Object[0]);
        log.info(String.format("Found schema bean definition parser %s from resource %s", parser.getClass(), "META-INF/citrus/schema/parser/" + fileExtension));
        SCHEMA_PARSER.put(fileExtension, parser);
        return parser;
    }
}

