/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.util;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;

public abstract class BeanDefinitionParserUtils {
    private BeanDefinitionParserUtils() {
    }

    public static void setPropertyValue(BeanDefinitionBuilder builder, String propertyValue, String propertyName) {
        if (StringUtils.hasText((String)propertyValue)) {
            builder.addPropertyValue(propertyName, (Object)propertyValue);
        }
    }

    public static void setConstructorArgValue(BeanDefinitionBuilder builder, String propertyValue) {
        if (StringUtils.hasText((String)propertyValue)) {
            builder.addConstructorArgValue((Object)propertyValue);
        }
    }

    public static void setPropertyReference(BeanDefinitionBuilder builder, String beanReference, String propertyName) {
        if (StringUtils.hasText((String)beanReference)) {
            builder.addPropertyReference(propertyName, beanReference);
        }
    }

    public static void addConstructorArgReference(BeanDefinitionBuilder builder, String beanReference) {
        if (StringUtils.hasText((String)beanReference)) {
            builder.addConstructorArgReference(beanReference);
        }
    }

    public static void setPropertyReference(BeanDefinitionBuilder builder, String beanReference, String propertyName, String defaultValue) {
        if (StringUtils.hasText((String)beanReference)) {
            builder.addPropertyReference(propertyName, beanReference);
        } else {
            builder.addPropertyReference(propertyName, defaultValue);
        }
    }

    public static BeanDefinitionHolder registerBean(String beanId, Class<?> beanClass, ParserContext parserContext, boolean shouldFireEvents) {
        return BeanDefinitionParserUtils.registerBean(beanId, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(beanClass).getBeanDefinition(), parserContext, shouldFireEvents);
    }

    public static BeanDefinitionHolder registerBean(String beanId, BeanDefinition beanDefinition, ParserContext parserContext, boolean shouldFireEvents) {
        if (parserContext.getRegistry().containsBeanDefinition(beanId)) {
            return new BeanDefinitionHolder(parserContext.getRegistry().getBeanDefinition(beanId), beanId);
        }
        BeanDefinitionHolder configurationHolder = new BeanDefinitionHolder(beanDefinition, beanId);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)configurationHolder, (BeanDefinitionRegistry)parserContext.getRegistry());
        if (shouldFireEvents) {
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(configurationHolder);
            parserContext.registerComponent((ComponentDefinition)componentDefinition);
        }
        return configurationHolder;
    }
}

