/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.handler;

import java.util.Map;
import org.citrusframework.config.xml.DefaultMessageQueueParser;
import org.citrusframework.config.xml.DirectEndpointAdapterParser;
import org.citrusframework.config.xml.DirectEndpointParser;
import org.citrusframework.config.xml.DirectSyncEndpointParser;
import org.citrusframework.config.xml.EmptyResponseEndpointAdapterParser;
import org.citrusframework.config.xml.FunctionLibraryParser;
import org.citrusframework.config.xml.GlobalVariablesParser;
import org.citrusframework.config.xml.MessageValidatorRegistryParser;
import org.citrusframework.config.xml.NamespaceContextParser;
import org.citrusframework.config.xml.RequestDispatchingEndpointAdapterParser;
import org.citrusframework.config.xml.SchemaParser;
import org.citrusframework.config.xml.SchemaRepositoryParser;
import org.citrusframework.config.xml.SequenceAfterSuiteParser;
import org.citrusframework.config.xml.SequenceAfterTestParser;
import org.citrusframework.config.xml.SequenceBeforeSuiteParser;
import org.citrusframework.config.xml.SequenceBeforeTestParser;
import org.citrusframework.config.xml.StaticResponseEndpointAdapterParser;
import org.citrusframework.config.xml.TestActorParser;
import org.citrusframework.config.xml.TimeoutProducingEndpointAdapterParser;
import org.citrusframework.config.xml.ValidationMatcherLibraryParser;
import org.citrusframework.config.xml.parser.CitrusXmlConfigParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class CitrusConfigNamespaceHandler
extends NamespaceHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CitrusConfigNamespaceHandler.class);

    public void init() {
        this.registerBeanDefinitionParser("schema-repository", new SchemaRepositoryParser());
        this.registerBeanDefinitionParser("schema", new SchemaParser());
        this.registerBeanDefinitionParser("actor", new TestActorParser());
        this.registerBeanDefinitionParser("global-variables", new GlobalVariablesParser());
        this.registerBeanDefinitionParser("message-validators", new MessageValidatorRegistryParser());
        this.registerBeanDefinitionParser("namespace-context", new NamespaceContextParser());
        this.registerBeanDefinitionParser("function-library", new FunctionLibraryParser());
        this.registerBeanDefinitionParser("validation-matcher-library", new ValidationMatcherLibraryParser());
        this.registerBeanDefinitionParser("before-suite", new SequenceBeforeSuiteParser());
        this.registerBeanDefinitionParser("before-test", new SequenceBeforeTestParser());
        this.registerBeanDefinitionParser("after-suite", new SequenceAfterSuiteParser());
        this.registerBeanDefinitionParser("after-test", new SequenceAfterTestParser());
        this.registerBeanDefinitionParser("direct-endpoint", (BeanDefinitionParser)new DirectEndpointParser());
        this.registerBeanDefinitionParser("direct-sync-endpoint", (BeanDefinitionParser)new DirectSyncEndpointParser());
        this.registerBeanDefinitionParser("queue", new DefaultMessageQueueParser());
        this.registerBeanDefinitionParser("message-queue", new DefaultMessageQueueParser());
        this.registerBeanDefinitionParser("direct-endpoint-adapter", (BeanDefinitionParser)new DirectEndpointAdapterParser());
        this.registerBeanDefinitionParser("dispatching-endpoint-adapter", (BeanDefinitionParser)new RequestDispatchingEndpointAdapterParser());
        this.registerBeanDefinitionParser("static-response-adapter", (BeanDefinitionParser)new StaticResponseEndpointAdapterParser());
        this.registerBeanDefinitionParser("empty-response-adapter", (BeanDefinitionParser)new EmptyResponseEndpointAdapterParser());
        this.registerBeanDefinitionParser("timeout-producing-adapter", (BeanDefinitionParser)new TimeoutProducingEndpointAdapterParser());
        this.lookupBeanDefinitionParser();
    }

    private void lookupBeanDefinitionParser() {
        Map actionParserMap = CitrusXmlConfigParser.lookup("core");
        actionParserMap.forEach((k, p) -> {
            this.registerBeanDefinitionParser((String)k, (BeanDefinitionParser)p);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Register bean definition parser %s from resource %s", p.getClass(), k));
            }
        });
    }
}

