/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel;

import java.util.LinkedHashMap;
import java.util.Map;
import org.citrusframework.channel.ChannelEndpointConfiguration;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;

public class ChannelMessageConverter
implements MessageConverter<org.springframework.messaging.Message<?>, org.springframework.messaging.Message<?>, ChannelEndpointConfiguration> {
    public org.springframework.messaging.Message<?> convertOutbound(Message internalMessage, ChannelEndpointConfiguration endpointConfiguration, TestContext context) {
        if (endpointConfiguration.isUseObjectMessages()) {
            return MessageBuilder.withPayload((Object)internalMessage).build();
        }
        LinkedHashMap headers = new LinkedHashMap();
        for (Map.Entry headerEntry : internalMessage.getHeaders().entrySet()) {
            if (endpointConfiguration.isFilterInternalHeaders()) {
                if (((String)headerEntry.getKey()).startsWith("citrus_")) continue;
                headers.put((String)headerEntry.getKey(), headerEntry.getValue());
                continue;
            }
            if (((String)headerEntry.getKey()).equals("citrus_message_id") || ((String)headerEntry.getKey()).equals("citrus_message_timestamp")) continue;
            headers.put((String)headerEntry.getKey(), headerEntry.getValue());
        }
        return MessageBuilder.withPayload((Object)internalMessage.getPayload()).copyHeaders(headers).build();
    }

    public Message convertInbound(org.springframework.messaging.Message<?> externalMessage, ChannelEndpointConfiguration endpointConfiguration, TestContext context) {
        if (externalMessage == null) {
            return null;
        }
        LinkedHashMap messageHeaders = new LinkedHashMap(externalMessage.getHeaders());
        Object payload = externalMessage.getPayload();
        if (payload instanceof Message) {
            Message nestedMessage = (Message)payload;
            for (Map.Entry headerEntry : messageHeaders.entrySet()) {
                if (endpointConfiguration.isFilterInternalHeaders()) {
                    if (((String)headerEntry.getKey()).startsWith("citrus_")) continue;
                    nestedMessage.setHeader((String)headerEntry.getKey(), headerEntry.getValue());
                    continue;
                }
                if (((String)headerEntry.getKey()).equals("citrus_message_id") || ((String)headerEntry.getKey()).equals("citrus_message_timestamp")) continue;
                nestedMessage.setHeader((String)headerEntry.getKey(), headerEntry.getValue());
            }
            return nestedMessage;
        }
        return new DefaultMessage(payload, messageHeaders);
    }

    public void convertOutbound(org.springframework.messaging.Message<?> externalMessage, Message internalMessage, ChannelEndpointConfiguration endpointConfiguration, TestContext context) {
    }
}

