/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel.selector;

import java.util.Map;
import org.citrusframework.channel.selector.AbstractMessageSelector;
import org.citrusframework.channel.selector.MessageSelectorFactory;
import org.citrusframework.context.TestContext;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.xml.xpath.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.springframework.xml.xpath.XPathParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;

public class XpathPayloadMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_PREFIX = "xpath:";
    private static final Logger logger = LoggerFactory.getLogger(XpathPayloadMessageSelector.class);

    public XpathPayloadMessageSelector(String selectKey, String matchingValue, TestContext context) {
        super(selectKey.substring(SELECTOR_PREFIX.length()), matchingValue, context);
    }

    public boolean accept(Message<?> message) {
        Document doc;
        try {
            doc = XMLUtils.parseMessagePayload((String)this.getPayloadAsString(message));
        }
        catch (LSException e) {
            logger.warn("Ignoring non XML message for XPath message selector (" + e.getClass().getName() + ")");
            return false;
        }
        try {
            String value;
            Map namespaces = XMLUtils.lookupNamespaces((Node)doc);
            namespaces.putAll(this.context.getNamespaceContextBuilder().getNamespaceMappings());
            if (XPathUtils.hasDynamicNamespaces((String)this.selectKey)) {
                namespaces.putAll(XPathUtils.getDynamicNamespaces((String)this.selectKey));
                value = XPathExpressionFactory.createXPathExpression((String)XPathUtils.replaceDynamicNamespaces((String)this.selectKey, (Map)namespaces), (Map)namespaces).evaluateAsString((Node)doc);
            } else {
                value = XPathExpressionFactory.createXPathExpression((String)this.selectKey, (Map)namespaces).evaluateAsString((Node)doc);
            }
            return this.evaluate(value);
        }
        catch (XPathParseException e) {
            logger.warn("Could not evaluate XPath expression for message selector - ignoring message (" + ((Object)((Object)e)).getClass().getName() + ")");
            return false;
        }
    }

    public static class Factory
    implements MessageSelectorFactory<XpathPayloadMessageSelector> {
        @Override
        public boolean supports(String key) {
            return key.startsWith(XpathPayloadMessageSelector.SELECTOR_PREFIX);
        }

        @Override
        public XpathPayloadMessageSelector create(String key, String value, TestContext context) {
            return new XpathPayloadMessageSelector(key, value, context);
        }
    }
}

