/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.annotation;

import org.citrusframework.TestActor;
import org.citrusframework.channel.ChannelMessageConverter;
import org.citrusframework.channel.ChannelSyncEndpoint;
import org.citrusframework.channel.ChannelSyncEndpointBuilder;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.config.annotation.ChannelSyncEndpointConfig;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;

public class ChannelSyncEndpointConfigParser
implements AnnotationConfigParser<ChannelSyncEndpointConfig, ChannelSyncEndpoint> {
    public ChannelSyncEndpoint parse(ChannelSyncEndpointConfig annotation, ReferenceResolver referenceResolver) {
        ChannelSyncEndpointBuilder builder = new ChannelSyncEndpointBuilder();
        String channel = annotation.channel();
        String channelName = annotation.channelName();
        if (StringUtils.hasText((String)channel)) {
            builder.channel((MessageChannel)referenceResolver.resolve(annotation.channel(), MessageChannel.class));
        }
        if (StringUtils.hasText((String)channelName)) {
            builder.channel(annotation.channelName());
        }
        if (StringUtils.hasText((String)annotation.messagingTemplate())) {
            String messagingTemplate = "messagingTemplate";
            if (StringUtils.hasText((String)annotation.messagingTemplate())) {
                messagingTemplate = annotation.messagingTemplate();
            }
            builder.messagingTemplate((MessagingTemplate)referenceResolver.resolve(messagingTemplate, MessagingTemplate.class));
        }
        builder.useObjectMessages(annotation.useObjectMessages());
        builder.filterInternalHeaders(annotation.filterInternalHeaders());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((ChannelMessageConverter)referenceResolver.resolve(annotation.messageConverter(), ChannelMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.channelResolver())) {
            builder.channelResolver((DestinationResolver)referenceResolver.resolve(annotation.channelResolver(), DestinationResolver.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        return (ChannelSyncEndpoint)builder.initialize().build();
    }
}

