/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.actions.HttpServerResponseActionBuilder;
import org.citrusframework.openapi.AutoFillType;
import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.actions.OpenApiActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientResponseActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerResponseActionBuilder;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.openapi.validation.OpenApiMessageValidationContext;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.yaml.actions.Message;
import org.citrusframework.yaml.actions.Receive;
import org.citrusframework.yaml.actions.Send;

public class OpenApi
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    private OpenApiSpecificationSourceAwareBuilder<?> builder;
    private Receive receive;
    private Send send;
    private String description;
    private String actor;
    private ReferenceResolver referenceResolver;

    public void setDescription(String value) {
        this.description = value;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setSpecification(String specification) {
        this.builder = new OpenApiActionBuilder().specification(specification);
    }

    public void setClient(String httpClient) {
        this.builder = ((OpenApiActionBuilder)this.builder).client(httpClient);
    }

    public void setServer(String httpServer) {
        this.builder = ((OpenApiActionBuilder)this.builder).server(httpServer);
    }

    public void setSendRequest(ClientRequest request) {
        OpenApiClientRequestActionBuilder requestBuilder = this.asClientBuilder().send(request.getOperation());
        requestBuilder.name("openapi:send-request");
        requestBuilder.description(this.description);
        requestBuilder.autoFill(request.autoFill);
        this.send = new Send((SendMessageAction.SendMessageActionBuilder)requestBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (request.fork != null) {
            this.send.setFork(request.fork);
        }
        if (request.extract != null) {
            this.send.setExtract(request.extract);
        }
        if (request.uri != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).header("citrus_endpoint_uri", (Object)request.uri);
        }
        this.builder = requestBuilder;
    }

    public void setReceiveResponse(ClientResponse response) {
        OpenApiClientResponseActionBuilder responseBuilder = this.asClientBuilder().receive(response.getOperation(), response.getStatus());
        responseBuilder.name("openapi:receive-response");
        responseBuilder.description(this.description);
        this.receive = new Receive((ReceiveMessageAction.ReceiveMessageActionBuilder)responseBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (response.timeout != null) {
            this.receive.setTimeout(response.timeout);
        }
        this.receive.setSelect(response.select);
        this.receive.setValidator(response.validator);
        this.receive.setValidators(response.validators);
        this.receive.setHeaderValidator(response.headerValidator);
        this.receive.setHeaderValidators(response.headerValidators);
        if (response.selector != null) {
            this.receive.setSelector(response.selector);
        }
        this.receive.setSelect(response.select);
        response.getValidates().forEach(this.receive.getValidate()::add);
        if (response.extract != null) {
            this.receive.setExtract(response.extract);
        }
        this.builder = responseBuilder;
    }

    public void setReceiveRequest(ServerRequest request) {
        OpenApiServerRequestActionBuilder requestBuilder = this.asServerBuilder().receive(request.getOperation());
        requestBuilder.name("openapi:receive-request");
        requestBuilder.description(this.description);
        this.receive = new Receive((ReceiveMessageAction.ReceiveMessageActionBuilder)requestBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (request.selector != null) {
            this.receive.setSelector(request.selector);
        }
        this.receive.setSelect(request.select);
        this.receive.setValidator(request.validator);
        this.receive.setValidators(request.validators);
        this.receive.setHeaderValidator(request.headerValidator);
        this.receive.setHeaderValidators(request.headerValidators);
        if (request.timeout != null) {
            this.receive.setTimeout(request.timeout);
        }
        request.getValidates().forEach(this.receive.getValidate()::add);
        if (request.extract != null) {
            this.receive.setExtract(request.extract);
        }
        this.builder = requestBuilder;
    }

    public void setSendResponse(ServerResponse response) {
        OpenApiServerResponseActionBuilder responseBuilder = this.asServerBuilder().send(response.getOperation(), response.getStatus());
        responseBuilder.name("openapi:send-response");
        responseBuilder.description(this.description);
        this.send = new Send((SendMessageAction.SendMessageActionBuilder)responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.extract != null) {
            this.send.setExtract(response.extract);
        }
        ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", (Object)response.getStatus());
        this.builder = responseBuilder;
    }

    public TestAction build() {
        OpenApiSpecificationSourceAwareBuilder<?> openApiSpecificationSourceAwareBuilder;
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing client or server Http action - please provide proper action details");
        }
        if (this.send != null) {
            this.send.setReferenceResolver(this.referenceResolver);
            this.send.setActor(this.actor);
            this.send.build();
        }
        if (this.receive != null) {
            this.receive.setReferenceResolver(this.referenceResolver);
            this.receive.setActor(this.actor);
            this.receive.build();
        }
        if ((openApiSpecificationSourceAwareBuilder = this.builder) instanceof ReceiveMessageAction.ReceiveMessageActionBuilder) {
            ReceiveMessageAction.ReceiveMessageActionBuilder receiveMessageActionBuilder = (ReceiveMessageAction.ReceiveMessageActionBuilder)openApiSpecificationSourceAwareBuilder;
            receiveMessageActionBuilder.validate((ValidationContext.Builder)OpenApiMessageValidationContext.Builder.openApi(this.builder.getOpenApiSpecificationSource().resolve(this.referenceResolver)));
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private OpenApiClientActionBuilder asClientBuilder() {
        OpenApiSpecificationSourceAwareBuilder<?> openApiSpecificationSourceAwareBuilder = this.builder;
        if (openApiSpecificationSourceAwareBuilder instanceof OpenApiClientActionBuilder) {
            OpenApiClientActionBuilder openApiClientActionBuilder = (OpenApiClientActionBuilder)openApiSpecificationSourceAwareBuilder;
            return openApiClientActionBuilder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to openapi client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    private OpenApiServerActionBuilder asServerBuilder() {
        OpenApiSpecificationSourceAwareBuilder<?> openApiSpecificationSourceAwareBuilder = this.builder;
        if (openApiSpecificationSourceAwareBuilder instanceof OpenApiServerActionBuilder) {
            OpenApiServerActionBuilder openApiServerActionBuilder = (OpenApiServerActionBuilder)openApiSpecificationSourceAwareBuilder;
            return openApiServerActionBuilder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to openapi server action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    public static class ClientRequest {
        protected String operation;
        protected String uri;
        protected Boolean fork;
        protected AutoFillType autoFill = OpenApiSettings.getRequestAutoFillRandomValues();
        protected Message.Extract extract;

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public Boolean getFork() {
            return this.fork;
        }

        public void setFork(Boolean fork) {
            this.fork = fork;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }

        public AutoFillType getAutoFill() {
            return this.autoFill;
        }

        public void setAutoFill(AutoFillType autoFill) {
            this.autoFill = autoFill;
        }
    }

    public static class ClientResponse {
        protected Integer timeout;
        protected String operation;
        protected String status = "200";
        protected String select;
        protected String validator;
        protected String validators;
        protected String headerValidator;
        protected String headerValidators;
        protected Receive.Selector selector;
        protected List<Receive.Validate> validates;
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class ServerRequest {
        protected Integer timeout;
        protected String operation;
        protected String select;
        protected String validator;
        protected String validators;
        protected String headerValidator;
        protected String headerValidators;
        protected Receive.Selector selector;
        protected List<Receive.Validate> validates;
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public void setValidates(List<Receive.Validate> validates) {
            this.validates = validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class ServerResponse {
        protected String operation;
        protected String status = "200";
        protected Message.Extract extract;

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }
}

