/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.report.ValidationReport;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.validation.OpenApiValidationContext;

public abstract class OpenApiValidator {
    protected final OpenApiInteractionValidator openApiInteractionValidator;

    protected OpenApiValidator(OpenApiSpecification openApiSpecification) {
        OpenApiValidationContext openApiValidationContext = openApiSpecification.getOpenApiValidationContext();
        this.openApiInteractionValidator = openApiValidationContext != null ? openApiSpecification.getOpenApiValidationContext().getOpenApiInteractionValidator() : null;
    }

    protected abstract String getType();

    protected String constructErrorMessage(OperationPathAdapter operationPathAdapter, ValidationReport report) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpenApi ");
        stringBuilder.append(this.getType());
        stringBuilder.append(" validation failed for operation: ");
        stringBuilder.append(operationPathAdapter);
        report.getMessages().forEach(message -> stringBuilder.append("\n\t").append(message));
        return stringBuilder.toString();
    }
}

